# Growth Strategy

## Growth Vectors

### Ansoff Matrix

| | Existing Products | New Products |
|---|---|---|
| **Existing Markets** | Market Penetration | Product Development |
| **New Markets** | Market Development | Diversification |

**Prioritization:** Penetration → Development → Diversification (risk increases)

## Market Expansion Framework

### New Market Entry Checklist

- [ ] **Market size:** TAM/SAM/SOM quantified
- [ ] **Customer need:** Validated through research, not assumption
- [ ] **Competitive landscape:** Can we differentiate?
- [ ] **Go-to-market:** Do we have distribution advantage?
- [ ] **Unit economics:** Can we acquire customers profitably?
- [ ] **Operational readiness:** Support, localization, compliance

### Geographic Expansion Criteria

| Factor | Assessment |
|--------|------------|
| Market size | Revenue potential > cost to enter |
| Language | Can we localize effectively? |
| Regulatory | Compliance requirements manageable? |
| Competition | Local competitors entrenched? |
| Distribution | GTM motion works there? |
| Support | Can we serve customers in timezone? |

### International Entry Modes

| Mode | Investment | Control | Risk |
|------|------------|---------|------|
| Export/Remote | Low | High | Low |
| Partnerships | Medium | Medium | Medium |
| Joint Venture | High | Shared | Medium |
| Acquisition | High | High | High |
| Subsidiary | Highest | Highest | Highest |

## Adjacent Market Strategy

### Adjacency Types

1. **Customer adjacencies** — Same customer, different need
2. **Product adjacencies** — New product, same capability
3. **Channel adjacencies** — Same product, new distribution
4. **Geographic adjacencies** — Same business, new region

### Adjacency Evaluation

```
ADJACENCY: [Description]

Fit Assessment:
- Leverages existing capabilities? [1-5]
- Uses existing distribution? [1-5]
- Serves existing customers? [1-5]
- Strengthens core business? [1-5]

Market Assessment:
- Size: $X TAM
- Growth: X% CAGR
- Competition: Low/Medium/High

TOTAL SCORE: [X/20] + Market attractiveness
RECOMMENDATION: Pursue / Explore / Pass
```

## Growth Initiative Prioritization

### ICE Scoring

| Criterion | Definition |
|-----------|------------|
| **Impact** | Revenue/growth potential if successful (1-10) |
| **Confidence** | Certainty we can execute (1-10) |
| **Ease** | Resources and time required (1-10) |

**Score = Impact × Confidence × Ease**

### Portfolio Balance

| Type | Allocation | Risk Profile |
|------|------------|--------------|
| **Core** | 70% | Low risk, incremental gains |
| **Adjacent** | 20% | Medium risk, step-out growth |
| **Transformational** | 10% | High risk, breakthrough potential |

## Growth Metrics

### Leading Indicators

- Pipeline growth
- Customer acquisition velocity
- Activation rate
- Expansion revenue %
- Net Revenue Retention

### Lagging Indicators

- Revenue growth
- Market share
- Customer lifetime value
- Gross margin
