# Competitive Intelligence

## Competitive Analysis Framework

### Porter's Five Forces

| Force | Assessment Questions |
|-------|---------------------|
| **Rivalry** | How intense is competition? Price wars? Feature races? |
| **New Entrants** | How easy to enter? What barriers exist? |
| **Substitutes** | What alternatives exist outside direct competitors? |
| **Buyer Power** | How much leverage do customers have? |
| **Supplier Power** | Dependencies on key vendors or platforms? |

### Competitor Profile Template

```
COMPETITOR: [Name]
Last Updated: [Date]

OVERVIEW
- Founded: Year | Employees: # | Funding: $X
- Target segment: Who they sell to
- Positioning: How they describe themselves

PRODUCT
- Core offering:
- Key features:
- Pricing model:
- Technology stack (if known):

STRATEGY
- Growth focus: (market expansion, product, both)
- Recent moves: (launches, pivots, acquisitions)
- Likely next moves:

STRENGTHS          | WEAKNESSES
- Strength 1       | - Weakness 1
- Strength 2       | - Weakness 2

THREAT LEVEL: Low / Medium / High
- Why:
```

## Competitive Moat Assessment

### Moat Types

| Moat | Description | Examples |
|------|-------------|----------|
| **Network effects** | Value increases with users | Marketplaces, social |
| **Switching costs** | Pain to leave | Enterprise software, data lock-in |
| **Brand** | Trusted reputation | Consumer trust, B2B credibility |
| **Scale** | Cost advantages from size | Manufacturing, infrastructure |
| **Regulatory** | Legal barriers to entry | Licenses, patents, compliance |
| **Data** | Proprietary insights | Training data, usage patterns |

### Moat Strength Checklist

- [ ] Can competitors replicate in < 2 years?
- [ ] Would it cost > $10M to replicate?
- [ ] Is the moat strengthening over time?
- [ ] Do customers explicitly value this advantage?

## Win/Loss Analysis

### Interview Questions (Lost Deals)

1. What triggered your search for a solution?
2. Who else did you evaluate?
3. What were your top 3 decision criteria?
4. How did we compare on each criterion?
5. What was the deciding factor?
6. What could have changed your decision?

### Win/Loss Tracking

| Deal | Result | Competitor | Reason | Pattern |
|------|--------|------------|--------|---------|
| Acme Corp | Lost | Competitor X | Price | 3rd price loss this quarter |
| Beta Inc | Won | Competitor Y | Integration | Technical fit wins |

## Competitive Response Playbook

### When Competitor Launches Feature

1. **Assess:** Is it core to our positioning?
2. **Analyze:** What's the actual capability vs announcement?
3. **Decide:** Ignore / Match / Leapfrog / Differentiate
4. **Communicate:** Sales enablement, customer talking points

### When Competitor Raises Funding

1. **Assume:** They'll use it aggressively
2. **Monitor:** Hiring patterns, ad spend, pricing changes
3. **Prepare:** Counter-narratives for sales, retention plays

### When Competitor Acquires

1. **Map:** Integration timeline (usually 12-18 months of chaos)
2. **Target:** Their unhappy customers
3. **Message:** Stability and focus vs distraction
