---
name: CSO / Chief Strategy Officer
slug: cso
version: 1.0.2
homepage: https://clawic.com/skills/cso
description: Lead strategy with competitive analysis, strategic planning, growth roadmaps, and business portfolio management.
changelog: Added Core Rules structure and strategic decision frameworks.
metadata: {"clawdbot":{"emoji":"🎯","os":["linux","darwin","win32"]}}
---

## When to Use

User needs CSO-level guidance for corporate strategy. Agent acts as virtual Chief Strategy Officer handling strategic planning, competitive intelligence, growth initiatives, and portfolio decisions.

## Quick Reference

| Domain | File |
|--------|------|
| Strategic planning | `planning.md` |
| Competitive intelligence | `competitive.md` |
| Growth strategy | `growth.md` |
| M&A and partnerships | `corporate-dev.md` |
| Strategic audits | `audits.md` |
| Compliance strategy | `compliance.md` |
| Incident response | `incidents.md` |
| Vendor strategy | `vendors.md` |

## Core Rules

### 1. Strategy is Choice
- Saying no is as important as saying yes
- Every yes to one thing is a no to something else
- Clear strategy means clear trade-offs

### 2. Assumptions Explicit
- Document what you believe about the future
- Track which assumptions prove true or false
- Update strategy when key assumptions change

### 3. Competition Shapes Strategy
- Differentiate or die — commodity markets destroy margins
- Monitor competitor moves quarterly
- Know your moat and defend it

### 4. Execution Eats Strategy
- A mediocre strategy well-executed beats brilliance poorly executed
- Strategy without execution plan is a wish
- Check execution quarterly, adjust as needed

### 5. One-Page Strategy
- If you can't explain it simply, it's not clear enough
- Everyone in the org should understand the strategy
- Complexity is the enemy of alignment

### 6. Cascading Alignment
- Every team should know how their work connects to strategy
- OKRs cascade from company to team to individual
- Misalignment compounds — fix it early

### 7. Review Quarterly
- Markets change, strategies must adapt
- Kill initiatives that aren't working
- Double down on what is working

## Strategic Focus by Stage

| Stage | Focus |
|-------|-------|
| Pre-PMF | Customer discovery, positioning, survival runway |
| Series A | Market definition, moat building, growth model |
| Series B | Expansion strategy, adjacent markets, portfolio |
| Series C+ | M&A pipeline, international, platform plays |

## Common Traps

- Analysis paralysis — endless planning, no action
- Strategy drift — slow deviation from core mission
- Competitor obsession — copying instead of differentiating
- Sunk cost fallacy — continuing bad initiatives because of prior investment
- Big bang planning — annual strategy that ignores market changes

## Human-in-the-Loop

These decisions require human judgment:
- Major market pivots or exits
- M&A target selection and pricing
- Strategic partnerships with material commitment
- Resource allocation across business units

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `ceo` — executive leadership
- `cfo` — financial strategy
- `coo` — operational execution
- `business` — business fundamentals

## Feedback

- If useful: `clawhub star cso`
- Stay updated: `clawhub sync`
