# 中文技术博客写作风格指南

> 本指南基于 blog-writer skill 的写作方法论，针对中文技术博客进行本地化。

---

## 核心原则

### 1. 不要 AI 味

AI 生成的文章有明显的"味道"：
- 过度使用连接词（首先、其次、最后）
- 每段都有总结
- 语言过于正式和书面化
- 缺乏个人观点和情绪

**我们要的是**：像跟朋友聊天一样写技术文章。

### 2. 有观点、有态度

不要写"客观中立"的流水账。好的技术文章应该有：
- 明确的立场（这个工具好用/不好用）
- 个人判断（我推荐/不推荐）
- 真实感受（踩坑的痛苦、解决后的爽感）

### 3. 具体胜过抽象

❌ "这个工具可以提高开发效率"
✅ "用了这个工具后，我每天能省出 30 分钟摸鱼时间"

---

## 开头模式

### 好的开头示例

**个人经历型：**
- "搞了两个小时，终于把这个坑填上了。记录一下，免得下次又踩。"
- "说实话，我一开始是拒绝用 Docker 的。直到上周部署炸了..."
- "作为一个写了 5 年 Python 的人，我可以负责任地说：这个库真的香。"

**观点输出型：**
- "我知道这个观点可能有争议，但我还是要说：XXX 被高估了。"
- "用了三个月 XXX 之后，我想聊聊它的真实体验。"
- "很多教程都没告诉你的一件事是..."

**问题驱动型：**
- "你有没有遇到过这种情况：XXX？我有，而且被折腾得够呛。"
- "如果你也在纠结 A 和 B 怎么选，这篇文章可能对你有帮助。"

### 避免的开头

❌ "随着人工智能的快速发展..."
❌ "在当今数字化时代..."
❌ "众所周知，XXX 是一个重要的技术..."
❌ "本文将介绍..."

---

## 结构模板

```markdown
# [直接、有态度的标题]

[开头：1-2句话，抛出核心观点或问题，吸引读者继续看]

### 背景 / 问题是什么

[简短说明遇到了什么问题，或者为什么要写这篇文章]
[2-3个短段落即可]

### 过程 / 怎么解决的

[具体的操作步骤、代码、截图]
[这部分可以长一些，但要分小节]

#### 小节1
[具体内容]

#### 小节2
[具体内容]

### 踩坑记录 / 注意事项

[遇到的问题和解决方案]
[这部分读者最爱看]

### 写在最后

[个人感想、总结、或者对读者的建议]
[不要写"综上所述"，写点真实的想法]
```

---

## 标题技巧

### 好标题的特点

1. **有数字**
   - "3 个坑让我搞了 2 小时"
   - "5 分钟搞定 XXX"
   - "我用 XXX 的 100 天"

2. **有冲突/转折**
   - "XXX 官方文档没告诉你的事"
   - "为什么我放弃了 XXX"
   - "从入门到放弃，再到真香"

3. **有悬念**
   - "没想到最后是这样解决的"
   - "一个让我困惑了三天的 Bug"
   - "这个功能藏得太深了"

4. **有态度**
   - "XXX 真的有必要吗？"
   - "别再用 XXX 了"
   - "XXX：被低估的神器"

### 避免的标题

❌ "浅谈 XXX"
❌ "XXX 技术详解"
❌ "关于 XXX 的一些思考"
❌ "XXX 入门教程"（太普通）

---

## 语言风格

### 推荐用词

| 场景 | 推荐 | 避免 |
|------|------|------|
| 表达观点 | "说实话"、"坦白讲"、"我觉得" | "笔者认为"、"不难发现" |
| 遇到问题 | "踩了个坑"、"折腾了半天"、"卡住了" | "遇到了一些困难" |
| 解决问题 | "搞定了"、"终于跑通了"、"真香" | "成功解决了该问题" |
| 推荐 | "强烈推荐"、"真的好用"、"谁用谁知道" | "值得一试" |
| 不推荐 | "别用"、"坑太多"、"不值得" | "不太建议使用" |
| 转折 | "但是"、"不过"、"话说回来" | "然而"、"但值得注意的是" |

### 避免的表达

❌ "首先...其次...最后..."
❌ "值得注意的是"
❌ "综上所述"
❌ "不难发现"
❌ "众所周知"
❌ "笔者"（直接用"我"）

### 可以用的口语化表达

- "说白了就是..."
- "简单来说..."
- "划重点："
- "敲黑板："
- "血泪教训："
- "真香警告："

---

## 段落和排版

### 段落长度

- **每段 2-4 句话**，最多不超过 5 句
- **单句成段**用于强调重点
- **每 150-250 字**加一个小标题

### 小标题使用

- 用 `###` 作为主要小标题
- 用 `####` 作为次级小标题
- 小标题要**具体**，不要太抽象

✅ "### 安装 Docker"
❌ "### 第一步"

✅ "### 为什么选择 FastAPI"
❌ "### 技术选型"

### 代码块

- 代码块前后要有说明
- 长代码要加注释
- 关键代码可以用 `行内代码` 高亮

### 列表使用

- 列表用于**真正的列举**，不要用于正文
- 3-7 项最佳，太长就分组
- 每项保持简短

---

## 个人经历融入

### 什么时候用

- 说明为什么要研究这个话题
- 分享踩坑经历
- 给出推荐/不推荐的理由

### 怎么写

**包含具体细节：**
- 时间："上周"、"用了三个月"
- 数字："试了 5 种方案"、"花了 2 小时"
- 场景："在部署到生产环境时"

**连接到主题：**
个人经历要服务于文章主题，不要跑题。

### 示例

> 上周部署一个 Python 项目，死活跑不起来。查了两个小时，最后发现是 Python 版本的问题。这件事让我意识到，环境管理真的太重要了。所以今天想聊聊 pyenv 这个工具。

---

## 结尾模式

### 好的结尾

**行动号召型：**
- "如果你也遇到类似的问题，不妨试试这个方案。"
- "有问题欢迎评论区交流。"

**个人感想型：**
- "折腾了这么久，总算搞明白了。希望这篇文章能帮到你。"
- "虽然过程很痛苦，但学到了不少东西。"

**前瞻型：**
- "下一篇打算写 XXX，感兴趣的可以关注一下。"
- "这个领域还有很多值得探索的地方。"

### 避免的结尾

❌ "综上所述，本文介绍了..."
❌ "希望本文对读者有所帮助。"
❌ "以上就是本文的全部内容。"

---

## 新闻资讯类文章

写新闻汇总、行业日报、资讯盘点等文章时，有额外要求：

### 必须附带原文链接

每条新闻都要有跳转链接，方便读者查看原文详情。

**格式选择：**

1. **标题即链接**（推荐）
   ```markdown
   ### [特斯拉宣布停产 Model S/X](https://example.com/news/123)
   ```

2. **末尾标注**
   ```markdown
   ### 特斯拉宣布停产 Model S/X
   
   新闻内容...
   
   👉 [查看原文](https://example.com/news/123)
   ```

3. **来源标注**（链接不可用时）
   ```markdown
   ### 特斯拉宣布停产 Model S/X
   
   新闻内容...（来源：36氪）
   ```

### 新闻摘要写法

- 用自己的话概括，不要直接复制原文
- 加入简短点评，体现个人观点
- 保持每条新闻 50-150 字

---

## 检查清单

发布前检查：

- [ ] 标题是否有吸引力？
- [ ] 开头是否直接切入主题？
- [ ] 是否有"首先、其次、最后"等模板句式？
- [ ] 段落是否太长（超过 5 句）？
- [ ] 是否有个人观点和态度？
- [ ] 结尾是否自然？
- [ ] 通读一遍，像不像跟朋友聊天？
- [ ] **新闻类文章**：每条新闻是否都有原文链接？

---

## 参考资源

- `examples/` 目录中的示例文章
- `skills/blog-writer/` 中的英文风格指南（可参考结构）
- 优秀的中文技术博客：阮一峰、酷壳、美团技术博客

---

*最后更新：2025-02-02*
