---
name: crypton-esim
description: Purchase anonymous eSIMs with BTC/XMR/card - no account required
---

# Crypton eSIM

Purchase anonymous eSIMs directly from chat. Pay with Bitcoin, Monero, or card - no account required.

## Triggers

- esim
- e-sim
- mobile data
- travel data
- buy esim
- get esim
- data plan
- roaming

## Commands

### esim
Browse and purchase eSIMs for 170+ countries.

**Usage:** `esim [country]`

**Examples:**
- `esim` - Show available countries
- `esim germany` - Show plans for Germany  
- `esim DE` - Show plans by country code

### buy
Purchase an eSIM plan with your preferred payment method.

**Usage:** `buy [package_id] with [payment_method]`

**Payment methods:** `btc`, `xmr`, `card` (or `stripe`)

**Examples:**
- `buy DE_1_7 with btc` - Buy Germany 1GB/7days with Bitcoin
- `buy US_5_30 with xmr` - Buy USA 5GB/30days with Monero
- `buy FR_3_14 with card` - Buy France 3GB/14days with card

### status
Check the status of an existing order.

**Usage:** `status [order_uuid]`

**Examples:**
- `status a1b2c3d4-e5f6-7890-abcd-ef1234567890`

### help
Show available commands and usage information.

**Usage:** `help`

## Features

- Browse eSIM plans for 170+ countries
- Anonymous purchases - no account needed
- Pay with Bitcoin (BTC), Monero (XMR), or credit card
- Real-time order status tracking
- Get activation codes and QR codes
- No API key required

## Example Conversation

```
User: esim

Bot: 🌍 Available eSIM Destinations

• Germany (DE) - from €1.40 (15 plans)
• France (FR) - from €1.75 (13 plans)
• United States (US) - from €3.25 (12 plans)
...

Type `esim [country]` to see plans.

---

User: esim germany

Bot: 📱 eSIM Plans for Germany

| Data | Validity | Price | Package ID |
|------|----------|-------|------------|
| 500 MB | 1 day | €1.40 | DE_0.5_Daily |
| 1.0 GB | 7 days | €2.45 | DE_1_7 |
| 3.0 GB | 30 days | €6.00 | DE_3_30 |

To purchase: `buy [package_id] with btc/xmr/card`

---

User: buy DE_1_7 with btc

Bot: ✅ Order Created

**Plan:** Germany 1GB 7Days
**Data:** 1.0 GB
**Validity:** 7 days  
**Price:** €2.45

**Payment Method:** Bitcoin
**Amount:** `0.00004521 BTC`
**Address:** `bc1qxy2kgdygjrsqtzq2n0yrf2493p83kkfjhx0wlh`

Order ID: `a1b2c3d4-e5f6-7890-abcd-ef1234567890`

Send payment to complete your order.

---

User: status a1b2c3d4-e5f6-7890-abcd-ef1234567890

Bot: ✅ Order Complete

**Plan:** Germany 1GB 7Days
**Data Remaining:** 1024 MB
**ICCID:** 8901234567890123456

**Activation Code:**
```
LPA:1$smdp.example.com$ACTIVATION-CODE
```

Scan the QR code or enter the activation code in your phone's eSIM settings.
```

## API

This skill uses the Crypton Guest eSIM API.

- **Base URL:** `https://crypton.sh/api/v1/guest/esim`
- **Authentication:** None required
- **Documentation:** https://crypton.sh/esim/guest

### Endpoints

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/plans` | List available eSIM plans |
| GET | `/countries` | List countries with plans |
| POST | `/checkout` | Create a purchase |
| GET | `/order/{uuid}` | Check order status |
| POST | `/refresh/{uuid}` | Refresh usage data |

### Rate Limits

- GET endpoints: 30 requests/minute
- POST /checkout: 10 requests/minute
- POST /refresh: 5 requests/minute

## Configuration

| Variable | Default | Description |
|----------|---------|-------------|
| `api_base_url` | `https://crypton.sh/api/v1/guest/esim` | API endpoint |
| `default_payment_method` | `btc` | Default payment (btc, xmr, stripe) |

## Dependencies

- Python 3.7+
- requests library

## Files

- `SKILL.md` - This file
- `crypton_esim.py` - Skill implementation
- `README.md` - Additional documentation
- `requirements.txt` - Python dependencies

## Testing

```bash
# Interactive mode
python crypton_esim.py

# Single command
python crypton_esim.py "esim germany"
```

## Support

- Website: https://crypton.sh
- API Docs: https://crypton.sh/esim/guest

## License

MIT
