---
name: Crypto Tools
slug: crypto-tools
description: Access crypto data, monitor portfolios, detect scams, and navigate exchanges with real-time APIs and security tools.
---

## What This Is

Practical crypto tooling — data access, monitoring, security. NOT investment advice, NOT blockchain technology (see `blockchain` skill).

**This skill:** How to get prices, track portfolios, avoid scams, use exchanges safely.  
**Blockchain skill:** How distributed ledgers work, smart contracts, when to use.

## ⚠️ Hard Boundaries (MANDATORY)

**NEVER do:**
- Recommend buying, selling, or holding any asset
- Predict prices or market movements
- Say anything is "good investment" or "safe"
- Give tax or legal advice for user's specific situation
- Urge immediate action ("act now", "don't miss")
- Express opinion on what user should do with money

**ALWAYS:**
- Include disclaimer when discussing investments
- Use descriptive language ("some investors consider..."), never prescriptive
- Remind to consult professionals for personal decisions
- Mention risks when investment topics arise

## Core Capabilities

| Task | How |
|------|-----|
| **Price data** | CoinGecko, CoinMarketCap APIs — real-time and historical |
| **Portfolio tracking** | Aggregate across exchanges/wallets, calculate performance |
| **On-chain queries** | Etherscan, Basescan, Solscan — balances, txs, contracts |
| **DeFi data** | DefiLlama (TVL), Dune (queries), The Graph (indexing) |
| **Scam detection** | TokenSniffer, RugDoc, CertiK — verify contracts, check audits |
| **Gas monitoring** | Track fees, suggest low-cost windows |
| **Alerts** | Price thresholds, whale movements, significant events |
| **Tax prep** | Export transaction history (CSV), cost basis calculation |

## Quick Reference

For detailed information by topic:

| Topic | File |
|-------|------|
| Data sources & APIs | `sources.md` |
| Security & scam detection | `security.md` |
| Utilities & calculations | `tools.md` |

## Example Interactions

✅ **Good:** "What's the current ETH price?" → Fetch from CoinGecko, return with 24h change  
✅ **Good:** "Check if this contract is safe: 0x..." → Query TokenSniffer, report findings  
✅ **Good:** "Export my transaction history for taxes" → Generate CSV with dates, amounts, prices  

❌ **Bad:** "Should I buy ETH now?" → "I can't recommend whether to buy. I can show you current price and recent trends. Consult a financial advisor for personal decisions."

## Standard Disclaimer

When user asks anything investment-related:

```
This is general information, not financial advice. 
Crypto is highly volatile — you can lose everything.
Consult a qualified professional before making decisions.
```

## Sources Priority

1. **Official APIs** — CoinGecko, CoinMarketCap, chain explorers
2. **Aggregators** — DefiLlama, Dune, The Graph
3. **Security** — TokenSniffer, CertiK, RugDoc
4. **Never** — Random Twitter influencers, Telegram signals
