---
name: crypto-self-learning
description: Self-learning system for crypto trading. Logs trades with full context (indicators, market conditions), analyzes patterns of wins/losses, and auto-updates trading rules. Use to log trades, analyze performance, identify what works/fails, and continuously improve trading accuracy.
metadata: {"openclaw":{"emoji":"🧠","requires":{"bins":["jq","python3"]}}}
---

# Crypto Self-Learning 🧠

AI-powered self-improvement system for crypto trading. Learn from every trade to increase accuracy over time.

## 🎯 Core Concept

Every trade is a lesson. This skill:
1. **Logs** every trade with full context
2. **Analyzes** patterns in wins vs losses
3. **Generates** rules from real data
4. **Updates** memory automatically

## 📝 Log a Trade

After EVERY trade (win or loss), log it:

```bash
python3 {baseDir}/scripts/log_trade.py \
  --symbol BTCUSDT \
  --direction LONG \
  --entry 78000 \
  --exit 79500 \
  --pnl_percent 1.92 \
  --leverage 5 \
  --reason "RSI oversold + support bounce" \
  --indicators '{"rsi": 28, "macd": "bullish_cross", "ma_position": "above_50"}' \
  --market_context '{"btc_trend": "up", "dxy": 104.5, "russell": "up", "day": "tuesday", "hour": 14}' \
  --result WIN \
  --notes "Clean setup, followed the plan"
```

### Required Fields:
| Field | Description | Example |
|-------|-------------|---------|
| `--symbol` | Trading pair | BTCUSDT |
| `--direction` | LONG or SHORT | LONG |
| `--entry` | Entry price | 78000 |
| `--exit` | Exit price | 79500 |
| `--pnl_percent` | Profit/Loss % | 1.92 or -2.5 |
| `--result` | WIN or LOSS | WIN |

### Optional but Recommended:
| Field | Description |
|-------|-------------|
| `--leverage` | Leverage used |
| `--reason` | Why you entered |
| `--indicators` | JSON with indicators at entry |
| `--market_context` | JSON with macro conditions |
| `--notes` | Post-trade observations |

## 📊 Analyze Performance

Run analysis to discover patterns:

```bash
python3 {baseDir}/scripts/analyze.py
```

Outputs:
- Win rate by direction (LONG vs SHORT)
- Win rate by day of week
- Win rate by RSI ranges
- Win rate by leverage
- Best/worst setups identified
- Suggested rules

### Analyze Specific Filters:
```bash
python3 {baseDir}/scripts/analyze.py --symbol BTCUSDT
python3 {baseDir}/scripts/analyze.py --direction LONG
python3 {baseDir}/scripts/analyze.py --min-trades 10
```

## 🧠 Generate Rules

Extract actionable rules from your trade history:

```bash
python3 {baseDir}/scripts/generate_rules.py
```

This analyzes patterns and outputs rules like:
```
🚫 AVOID: LONG when RSI > 70 (win rate: 23%, n=13)
✅ PREFER: SHORT on Mondays (win rate: 78%, n=9)
⚠️ CAUTION: Trades with leverage > 10x (win rate: 35%, n=20)
```

## 📈 Auto-Update Memory

Apply learned rules to agent memory:

```bash
python3 {baseDir}/scripts/update_memory.py --memory-path /path/to/MEMORY.md
```

This appends a "## 🧠 Learned Rules" section with data-driven insights.

### Dry Run (preview changes):
```bash
python3 {baseDir}/scripts/update_memory.py --memory-path /path/to/MEMORY.md --dry-run
```

## 📋 View Trade History

```bash
python3 {baseDir}/scripts/log_trade.py --list
python3 {baseDir}/scripts/log_trade.py --list --last 10
python3 {baseDir}/scripts/log_trade.py --stats
```

## 🔄 Weekly Review

Run weekly to see progress:

```bash
python3 {baseDir}/scripts/weekly_review.py
```

Generates:
- This week's performance vs last week
- New patterns discovered
- Rules that worked/failed
- Recommendations for next week

## 📁 Data Storage

Trades are stored in `{baseDir}/data/trades.json`:
```json
{
  "trades": [
    {
      "id": "uuid",
      "timestamp": "2026-02-02T13:00:00Z",
      "symbol": "BTCUSDT",
      "direction": "LONG",
      "entry": 78000,
      "exit": 79500,
      "pnl_percent": 1.92,
      "result": "WIN",
      "indicators": {...},
      "market_context": {...}
    }
  ]
}
```

## 🎯 Best Practices

1. **Log EVERY trade** - Wins AND losses
2. **Be honest** - Don't skip bad trades
3. **Add context** - More data = better patterns
4. **Review weekly** - Patterns emerge over time
5. **Trust the data** - If data says avoid something, AVOID IT

## 🔗 Integration with tess-cripto

Add to tess-cripto's workflow:
1. Before trade: Check rules in MEMORY.md
2. After trade: Log with full context
3. Weekly: Run analysis and update memory

---
*Skill by Total Easy Software - Learn from every trade* 🧠📈
