---
name: crypto-research
description: 加密货币投研分析框架，用于每日行情展望报告和市场实时监控。当需要：(1) 生成每日行情报告，(2) 分析BTC/ETH走势，(3) 监控市场资讯和币价异动，(4) 制定交易预案时使用此skill。
---

# 加密货币投研分析

专业的投研分析框架，用于生成行情展望报告和交易预案。

## 核心工作流程

### 1. 每日报告流程（UTC+8 9:00）

1. **收集情报** → 2. **宏观分析** → 3. **供需分析** → 4. **技术面** → 5. **情绪面** → 6. **预案** → 7. **结论**

### 2. 数据获取

使用以下API获取实时数据：

| 数据类型 | 数据源 | 获取方式 |
|---------|--------|---------|
| 币价 | Binance | `curl "https://api.binance.com/api/v3/ticker/24hr?symbol=BTCUSDT"` |
| 资金费率 | Binance | `curl "https://fapi.binance.com/fapi/v1/premiumIndex?symbol=BTCUSDT"` |
| 宏观资讯 | jin10 | web_fetch |
| 机构资金 | ARKM API | API key: e77c4a5d-f752-4a49-a49e-503970893e37 |
| 补充数据 | QVeris | skill工具 |

### 3. 报告结构

```
情报 → 宏观 → 供需 → 技术面 → 情绪 → 全场景预案 → 结论
```

## 报告要求

### 情报收集
- 过去24h重要事件
- TG群关键资讯（@MEcapital_bot）
- 宏观数据发布

### 宏观分析
- 政策/数据
- 地缘政治
- 市场风险偏好
- 品种价格表：价格 | 24h | 7d | 30d

### 供需层面
- 资金费率
- 链上指标（MVRV、STH-RP）
- ETF流向
- 机构动态

### 技术面
- 4小时线 + 30分钟线
- 缠论为主（笔、线段、中枢）
- 支撑/压力位

### 情绪面
- 恐慌指数
- 资金费率
- 多空比

### 全场景预案
- 剧本A（向上突破）：触发、目标、止损
- 剧本B（向下变盘）：触发、目标、止损
- 剧本C（震荡延续）：区间、策略

### 结论
- 核心判断（回答：市场在关注什么？）
- 操作建议
- 风险提示

## 报告思路

**不是堆砌数据，而是回答问题：什么在影响涨跌？市场在关注什么？**

**不是罗列指标，而是给出判断：基于这些数据，结论是什么？**

**不是机械执行，而是主动思考：需要监控什么？什么时候需要提醒用户？**

## 关键原则

1. **基于实时数据** - 每个报告必须使用当下真实数据
2. **分析框架不是内容模板** - 学习分析方法，不是复制旧内容
3. **回答核心问题** - 始终回答：市场在交易什么？
4. **主动提醒** - 发现重要信息时主动提醒用户

## 触发条件

- 用户要求生成行情报告
- 用户要求分析BTC/ETH走势
- 实时监控发现重大变化
- 需要制定交易预案
