# Supported Cryptocurrency Pairs

## Major Cryptocurrencies (Top 20 by Market Cap)

| Symbol | Name | Ticker | Example Query |
|--------|------|--------|---------------|
| BTC | Bitcoin | BTC-USDT | "BTC-USDT 支撑位" |
| ETH | Ethereum | ETH-USDT | "ETH-USDT 技术分析" |
| BNB | Binance Coin | BNB-USDT | "BNB-USDT 当前价格" |
| SOL | Solana | SOL-USDT | "SOL-USDT 关键水平" |
| XRP | Ripple | XRP-USDT | "XRP-USDT 压力位" |
| ADA | Cardano | ADA-USDT | "ADA-USDT 支撑位" |
| DOGE | Dogecoin | DOGE-USDT | "DOGE-USDT 分析" |
| DOT | Polkadot | DOT-USDT | "DOT-USDT 技术面" |
| AVAX | Avalanche | AVAX-USDT | "AVAX-USDT 交易建议" |
| MATIC | Polygon | MATIC-USDT | "MATIC-USDT 行情" |
| LINK | Chainlink | LINK-USDT | "LINK-USDT 指标" |
| UNI | Uniswap | UNI-USDT | "UNI-USDT 趋势" |
| ATOM | Cosmos | ATOM-USDT | "ATOM-USDT 分析" |
| LTC | Litecoin | LTC-USDT | "LTC-USDT 支撑" |
| BCH | Bitcoin Cash | BCH-USDT | "BCH-USDT 压力" |
| XLM | Stellar | XLM-USDT | "XLM-USDT 技术" |
| SHIB | Shiba Inu | SHIB-USDT | "SHIB-USDT 分析" |
| TRX | Tron | TRX-USDT | "TRX-USDT 水平" |
| ETC | Ethereum Classic | ETC-USDT | "ETC-USDT 交易" |
| FIL | Filecoin | FIL-USDT | "FIL-USDT 策略" |

## Popular Altcoins

### DeFi Tokens
| Symbol | Name | Ticker |
|--------|------|--------|
| AAVE | Aave | AAVE-USDT |
| COMP | Compound | COMP-USDT |
| MKR | Maker | MKR-USDT |
| SNX | Synthetix | SNX-USDT |
| SUSHI | SushiSwap | SUSHI-USDT |
| YFI | Yearn Finance | YFI-USDT |
| CRV | Curve DAO | CRV-USDT |
| BAL | Balancer | BAL-USDT |

### Layer 2 Solutions
| Symbol | Name | Ticker |
|--------|------|--------|
| OP | Optimism | OP-USDT |
| ARB | Arbitrum | ARB-USDT |
| METIS | Metis | METIS-USDT |
| SKL | SKALE | SKL-USDT |

### AI & Big Data
| Symbol | Name | Ticker |
|--------|------|--------|
| FET | Fetch.ai | FET-USDT |
| RNDR | Render | RNDR-USDT |
| GRT | The Graph | GRT-USDT |
| OCEAN | Ocean Protocol | OCEAN-USDT |
| AKT | Akash Network | AKT-USDT |

### Gaming & Metaverse
| Symbol | Name | Ticker |
|--------|------|--------|
| SAND | The Sandbox | SAND-USDT |
| MANA | Decentraland | MANA-USDT |
| AXS | Axie Infinity | AXS-USDT |
| GALA | Gala | GALA-USDT |
| ENJ | Enjin | ENJ-USDT |

### Infrastructure
| Symbol | Name | Ticker |
|--------|------|--------|
| NEAR | NEAR Protocol | NEAR-USDT |
| APT | Aptos | APT-USDT |
| SUI | Sui | SUI-USDT |
| TON | Toncoin | TON-USDT |
| INJ | Injective | INJ-USDT |

### Privacy Coins
| Symbol | Name | Ticker |
|--------|------|--------|
| XMR | Monero | XMR-USDT |
| ZEC | Zcash | ZEC-USDT |
| DASH | Dash | DASH-USDT |

### Meme Coins
| Symbol | Name | Ticker |
|--------|------|--------|
| PEPE | Pepe | PEPE-USDT |
| BONK | Bonk | BONK-USDT |
| WIF | dogwifhat | WIF-USDT |
| FLOKI | Floki | FLOKI-USDT |

## Stablecoins (for reference)

| Symbol | Name | Ticker |
|--------|------|--------|
| USDT | Tether | USDT-USD |
| USDC | USD Coin | USDC-USD |
| DAI | Dai | DAI-USD |
| BUSD | Binance USD | BUSD-USD |

## How to Query

### Standard Format
```
SYMBOL-USDT
```

### Examples
```
BTC-USDT 支撑位压力位
ETH-USDT 技术分析
SOL-USDT 当前价格和关键水平
```

### Multiple Pairs
```
BTC, ETH, SOL 的支撑位
```

### Alternative Queries
```
比特币 支撑位
以太坊 技术分析
```

## Adding New Pairs

If you want to add a new cryptocurrency pair:

1. **Check if it's listed on major exchanges** (Binance, Coinbase, Kraken)
2. **Verify USDT trading pair exists**
3. **Ensure sufficient liquidity** (daily volume > $1M)

### Request Format
```
[SYMBOL]-USDT
```

### Example
```
NEWCOIN-USDT
```

## Data Source Coverage

### CoinGecko
- **Coverage**: 10,000+ cryptocurrencies
- **Update**: Real-time
- **Rate Limit**: 50 calls/minute (free tier)

### Binance API
- **Coverage**: All Binance listed pairs
- **Update**: Real-time
- **Rate Limit**: 1200 requests/minute

### CoinMarketCap
- **Coverage**: 5,000+ cryptocurrencies
- **Update**: Real-time
- **Rate Limit**: 333 calls/day (free tier)

## Pair Format Variations

### Standard (Recommended)
```
BTC-USDT
ETH-USDT
```

### Alternative (Accepted)
```
BTCUSDT
ETHUSDT
```

### With Slash (Accepted)
```
BTC/USDT
ETH/USDT
```

## Regional Variations

### Chinese Users
```
BTC-USDT → 比特币-USDT
ETH-USDT → 以太坊-USDT
```

### Common Abbreviations
```
BTC → Bitcoin
ETH → Ethereum
SOL → Solana
BNB → Binance Coin
```

## Troubleshooting

### "Pair not found"
1. Check spelling (case-insensitive)
2. Verify USDT pair exists
3. Try alternative symbol name

### "No data available"
1. Check internet connection
2. Verify API is accessible
3. Try different data source

### "Insufficient liquidity"
1. Choose more liquid pairs
2. Check trading volume
3. Consider major cryptocurrencies

## Performance Tips

### Best Pairs for Analysis
- **High Liquidity**: BTC, ETH, BNB, SOL
- **Good Volume**: Most top 50 coins
- **Reliable Data**: Major exchanges listed

### Pairs to Avoid
- **Low Volume**: New or obscure coins
- **High Spread**: Low liquidity pairs
- **Unstable**: Frequent delistings

## Updates

This list is regularly updated. New pairs are added based on:
- Market capitalization
- Trading volume
- User requests
- Exchange listings

**Last Updated**: 2026-02-05
