# Crypto Levels Analyzer - 使用指南

## 🚀 快速开始

### 方式 1: 在线模式 (需要网络)

当网络可访问时，技能会自动获取实时数据：

```
BTC-USDT 支撑位压力位
ETH-USDT 技术分析
SOL-USDT 当前价格和关键水平
```

### 方式 2: 手动输入模式 (离线可用)

当网络不可用时，使用手动输入模式：

```bash
cd ~/.openclaw/skills/crypto-levels
python3 scripts/analyze_manual.py SOL-USDT
```

然后按提示输入：
1. 当前价格 (如: 177.70)
2. 24小时变化 (如: 2.31)
3. RSI 指标 (如: 60)

### 方式 3: 快速命令模式 (推荐)

直接通过命令行参数输入数据：

```bash
cd ~/.openclaw/skills/crypto-levels
python3 scripts/analyze_quick.py SOL 177.70 2.31 60
```

**参数说明**:
- `SOL` - 币种代码
- `177.70` - 当前价格
- `2.31` - 24小时变化 %
- `60` - RSI 指标

## 📊 SOL-USDT 分析示例

### 使用快速命令
```bash
python3 scripts/analyze_quick.py SOL 177.70 2.31 60
```

### 输出结果
```
📊 SOL-USDT 技术分析

💰 当前价格: $177.70
📈 24h变化: 🟢 +2.31%

🔴 压力位 (Resistance):
   • R1: $183.03 (+3.00%)
   • R2: $186.59 (+5.00%)
   • R3: $191.92 (+8.00%)

🟢 支撑位 (Support):
   • S1: $172.37 (-3.00%)
   • S2: $168.81 (-5.00%)
   • S3: $163.48 (-8.00%)

📊 技术指标:
   🟡 RSI: 60.0 (中性)
   📈 MA50: $174.15 (支撑)
   📈 MA100: $181.25 (阻力)

💡 交易建议:
   • 市场处于中性区间
   • 建议等待明确突破信号
   • 短期情绪: 中性

⚠️  风险提示: 本分析仅供参考，不构成投资建议。
```

## 🎯 常用币种价格参考

### 主要加密货币 (2026-02-05 参考价)
- **BTC**: $67,500
- **ETH**: $3,450
- **SOL**: $177.70
- **BNB**: $580
- **XRP**: $0.52
- **ADA**: $0.48
- **DOGE**: $0.085
- **DOT**: $7.20
- **AVAX**: $35.50
- **MATIC**: $0.58

### 如何获取最新价格

#### 方法 1: 交易所网站
- Binance: https://www.binance.com/zh-CN/trade/SOL_USDT
- OKX: https://www.okx.com/trade/sol-usdt
- Coinbase: https://www.coinbase.com/price/solana

#### 方法 2: 数据网站
- CoinGecko: https://www.coingecko.com/zh/currencies/solana
- CoinMarketCap: https://coinmarketcap.com/currencies/solana/
- 非小号: https://www.feixiaohao.com/currencies/solana/

#### 方法 3: 手机 App
- 币安 App
- OKX App
- 非小号 App

## 💡 使用技巧

### 1. 获取准确数据

#### 价格数据
```bash
# 访问交易所获取实时价格
# 例如: SOL-USDT 当前价格 $177.70
```

#### 24h 变化
```bash
# 计算公式: (当前价格 - 24小时前价格) / 24小时前价格 * 100
# 例如: (177.70 - 173.70) / 173.70 * 100 = 2.31%
```

#### RSI 指标
```bash
# 可以从 TradingView 或交易所获取
# 或者使用默认值 55 (中性)
```

### 2. 分析多个币种

#### 批量分析
```bash
# BTC
python3 scripts/analyze_quick.py BTC 67500 -0.5 58

# ETH
python3 scripts/analyze_quick.py ETH 3450 1.2 62

# SOL
python3 scripts/analyze_quick.py SOL 177.70 2.31 60
```

### 3. 保存分析结果

分析结果会自动保存到 `/tmp/crypto_analysis_quick.json`

```bash
# 查看保存的结果
cat /tmp/crypto_analysis_quick.json

# 复制到其他位置
cp /tmp/crypto_analysis_quick.json ~/crypto_analysis/
```

## 📈 交易决策指南

### 买入信号

#### 强买入信号
- RSI < 30 (超卖)
- 价格接近 S1 或 S2
- 24h 变化为负但幅度小
- MA50 是支撑

#### 谨慎买入信号
- RSI 30-40 (接近超卖)
- 价格接近 S3
- 24h 变化为正但幅度小
- 等待确认信号

### 卖出信号

#### 强卖出信号
- RSI > 70 (超买)
- 价格接近 R1 或 R2
- 24h 变化为正但幅度大
- MA50 是阻力

#### 谨慎卖出信号
- RSI 60-70 (接近超买)
- 价格接近 R3
- 24h 变化为负但幅度小
- 等待确认信号

### 止损设置

#### 短线交易
- 止损: S3 下方 1-2%
- 止盈: R1 或 R2
- 风险回报比: 1:2

#### 中线交易
- 止损: S3 下方 3-5%
- 止盈: R2 或 R3
- 风险回报比: 1:3

#### 长线交易
- 止损: S3 下方 5-10%
- 止盈: R3 或更高
- 风险回报比: 1:4

## 🔧 故障排除

### 问题: 网络无法访问 API

**解决方案**: 使用手动或快速模式
```bash
# 快速模式 (推荐)
python3 scripts/analyze_quick.py SOL 177.70 2.31 60

# 手动模式 (交互式)
python3 scripts/analyze_manual.py SOL-USDT
```

### 问题: 不知道当前价格

**解决方案**: 
1. 访问交易所网站
2. 查看手机 App
3. 使用数据网站
4. 参考常用币种价格表

### 问题: 不知道 RSI 值

**解决方案**: 
- 使用默认值 55 (中性)
- 或从 TradingView 查看
- 或忽略 RSI，只看支撑压力位

### 问题: 分析结果不准确

**可能原因**:
- 价格数据过时
- 市场突发新闻
- 低流动性币种

**建议**:
- 使用最新价格数据
- 结合多个时间框架
- 降低仓位，设置宽止损

## 📚 进阶使用

### 结合其他指标

#### 成交量分析
```bash
# 高成交量 + 支撑位 = 强支撑
# 高成交量 + 压力位 = 强压力
```

#### 趋势判断
```bash
# 价格 > MA50 > MA100 = 上涨趋势
# 价格 < MA50 < MA100 = 下跌趋势
# MA50 ≈ MA100 = 震荡趋势
```

#### 多时间框架
```bash
# 短线: 1H, 4H 图表
# 中线: 4H, 1D 图表
# 长线: 1D, 1W 图表
```

### 风险管理

#### 仓位计算
```python
# 单笔交易风险不超过总资金 2%
# 例如: 总资金 $10,000，单笔风险 $200

# 支撑位距离: $177.70 - $163.48 = $14.22
# 仓位大小: $200 / $14.22 = 14.06 SOL
```

#### 止盈策略
```python
# 分批止盈
# 第一批: R1 (30%仓位)
# 第二批: R2 (30%仓位)
# 第三批: R3 (40%仓位)
```

## 🎯 实战案例

### 案例 1: SOL-USDT 短线交易

**数据**:
- 价格: $177.70
- 24h变化: +2.31%
- RSI: 60 (中性)

**分析**:
- 支撑位: $172.37, $168.81, $163.48
- 压力位: $183.03, $186.59, $191.92
- MA50: $174.15 (支撑)
- MA100: $181.25 (阻力)

**决策**:
- **买入**: 等待回调到 $174 附近
- **止损**: $172 (下方 1.5%)
- **止盈**: $183 (上方 5%)
- **风险回报比**: 1:3.3

### 案例 2: BTC-USDT 波段交易

**数据**:
- 价格: $67,500
- 24h变化: -0.5%
- RSI: 58 (中性)

**分析**:
- 支撑位: $66,800, $65,500, $64,000
- 压力位: $68,200, $69,500, $71,000
- MA50: $66,500 (支撑)
- MA100: $65,200 (支撑)

**决策**:
- **买入**: $66,500 附近 (MA50)
- **止损**: $64,000 (下方 5%)
- **止盈**: $69,500 (上方 4.5%)
- **风险回报比**: 1:1.5

## 📊 数据来源

### 实时价格
- **Binance**: https://api.binance.com/api/v3/ticker/price
- **CoinGecko**: https://api.coingecko.com/api/v3/simple/price
- **OKX**: https://www.okx.com/api/v5/market/ticker

### 历史数据
- **CoinGecko**: 7天、30天、90天历史
- **TradingView**: 图表和技术指标
- **交易所**: 交易历史和K线

### 技术指标
- **TradingView**: RSI, MACD, Bollinger Bands
- **交易所**: 内置技术分析工具
- **专业工具**: 如 TradingView Pro

## ⚠️ 重要提醒

### 风险提示
1. **加密货币风险极高** - 价格波动剧烈
2. **可能快速亏损** - 不要投入超过承受能力的资金
3. **做好自己的研究** - 结合多种信息源
4. **这不是投资建议** - 仅用于学习和参考

### 最佳实践
1. **从小额开始** - 熟悉后再增加仓位
2. **设置止损** - 保护本金最重要
3. **分散投资** - 不要全仓一个币种
4. **持续学习** - 提升分析能力

## 📞 获取帮助

### 文档
- **快速开始**: [QUICKSTART.md](QUICKSTART.md)
- **完整说明**: [README.md](README.md)
- **技术指南**: [references/TECHNICAL_GUIDE.md](references/TECHNICAL_GUIDE.md)

### 社区
- OpenClaw 社区论坛
- 加密货币交易群组
- 技术分析讨论区

---

**最后更新**: 2026-02-05  
**版本**: 1.0.1
