---
name: crypto-levels
description: Analyze cryptocurrency support and resistance levels. Use when users ask about crypto price analysis, support/resistance levels, technical analysis for BTC, ETH, or other cryptocurrencies. Provides current price, key levels, and trading insights for crypto pairs like BTC-USDT, ETH-USDT.
---

# Crypto Levels Analyzer

## Quick Start

### Basic Usage

Ask about any cryptocurrency pair:

```
BTC-USDT 支撑位压力位
ETH-USDT 技术分析
SOL-USDT 当前价格和关键水平
```

### What You'll Get

- **Current Price**: Real-time price data
- **Support Levels**: Key price levels where buying interest may emerge
- **Resistance Levels**: Key price levels where selling pressure may increase
- **Technical Analysis**: Brief market sentiment and trading insights

## Supported Pairs

### Major Cryptocurrencies
- **BTC-USDT** - Bitcoin
- **ETH-USDT** - Ethereum
- **SOL-USDT** - Solana
- **BNB-USDT** - Binance Coin
- **XRP-USDT** - Ripple
- **ADA-USDT** - Cardano
- **DOGE-USDT** - Dogecoin
- **DOT-USDT** - Polkadot

### Altcoins
- **AVAX-USDT** - Avalanche
- **MATIC-USDT** - Polygon
- **LINK-USDT** - Chainlink
- **UNI-USDT** - Uniswap
- **ATOM-USDT** - Cosmos
- **LTC-USDT** - Litecoin
- **BCH-USDT** - Bitcoin Cash
- **XLM-USDT** - Stellar

*Note: Full list in [SUPPORTED_PAIRS.md](references/SUPPORTED_PAIRS.md)*

## How It Works

### Data Sources

The skill uses multiple data sources to calculate support and resistance levels:

1. **Price Data**: Current market price
2. **Historical Data**: Recent price action (24h, 7d, 30d)
3. **Volume Data**: Trading volume analysis
4. **Technical Indicators**: Moving averages, RSI, etc.

### Level Calculation

#### Support Levels (Buying Interest)
- **Primary Support**: Recent low + volume profile
- **Secondary Support**: Moving average crossovers
- **Tertiary Support**: Fibonacci retracement levels

#### Resistance Levels (Selling Pressure)
- **Primary Resistance**: Recent high + volume profile
- **Secondary Resistance**: Moving average resistance
- **Tertiary Resistance**: Fibonacci extension levels

### Analysis Methodology

```
1. Fetch current price and 24h data
2. Calculate recent highs/lows
3. Apply technical indicators
4. Generate support/resistance levels
5. Provide trading insights
```

## Usage Examples

### Example 1: Basic Query
**User**: "BTC-USDT 支撑位压力位"

**Response**:
```
📊 BTC-USDT 技术分析

💰 当前价格: $67,500
📈 24h变化: +2.5%

🔴 压力位 (Resistance):
• R1: $68,200 (近期高点)
• R2: $69,500 (心理关口)
• R3: $71,000 (历史阻力)

🟢 支撑位 (Support):
• S1: $66,800 (日内低点)
• S2: $65,500 (MA50)
• S3: $64,000 (强支撑)

💡 交易建议: 短期看涨，关注$68,200突破
```

### Example 2: Detailed Analysis
**User**: "ETH-USDT 详细技术分析"

**Response**:
```
📊 ETH-USDT 详细技术分析

💰 当前价格: $3,450
📈 24h变化: +3.2%
📉 7d变化: -1.5%

🔴 压力位 (Resistance):
• R1: $3,500 (心理关口)
• R2: $3,600 (近期高点)
• R3: $3,750 (斐波那契扩展)

🟢 支撑位 (Support):
• S1: $3,400 (日内支撑)
• S2: $3,300 (MA100)
• S3: $3,200 (强支撑区)

📊 技术指标:
• RSI: 62 (中性偏强)
• MACD: 金叉向上
• MA50: $3,350 (支撑)

💡 市场情绪: 看涨
💡 交易建议: 回调买入，突破追涨
```

### Example 3: Multiple Pairs
**User**: "BTC, ETH, SOL 的支撑位"

**Response**:
```
📊 多币种支撑位分析

BTC-USDT ($67,500)
• 支撑: $66,800, $65,500, $64,000
• 压力: $68,200, $69,500, $71,000

ETH-USDT ($3,450)
• 支撑: $3,400, $3,300, $3,200
• 压力: $3,500, $3,600, $3,750

SOL-USDT ($175)
• 支撑: $170, $165, $160
• 压力: $180, $185, $195
```

## Advanced Features

### Time Frame Analysis

#### Short-term (Intraday)
- Focus on 1h, 4h charts
- Key levels: Previous day high/low
- Best for: Day trading, scalping

#### Medium-term (Swing)
- Focus on 4h, daily charts
- Key levels: Weekly highs/lows
- Best for: Swing trading (3-7 days)

#### Long-term (Position)
- Focus on daily, weekly charts
- Key levels: Monthly highs/lows
- Best for: Position trading (weeks/months)

### Volume Analysis

The skill analyzes volume to confirm levels:

- **High Volume at Support**: Strong buying interest
- **High Volume at Resistance**: Strong selling pressure
- **Low Volume**: Weak levels, more likely to break

### Market Sentiment

Based on technical indicators:
- **Bullish**: RSI > 50, MACD positive
- **Bearish**: RSI < 50, MACD negative
- **Neutral**: RSI 40-60, mixed signals

## Risk Management

### Important Disclaimer

**This is not financial advice.** The skill provides technical analysis for educational purposes only.

### Trading Risks

- **Market Volatility**: Crypto markets are highly volatile
- **Liquidity Risk**: Low liquidity can cause slippage
- **Regulatory Risk**: Regulations can impact prices
- **Technical Risk**: System failures, exchange issues

### Recommended Practices

1. **Never invest more than you can afford to lose**
2. **Use stop-loss orders**
3. **Diversify your portfolio**
4. **Do your own research (DYOR)**
5. **Consider professional advice**

## Configuration

### API Settings

The skill can be configured to use different data sources:

```json
{
  "crypto-levels": {
    "dataSource": "coingecko",  // or "binance", "coinmarketcap"
    "updateInterval": 60,       // seconds
    "cacheDuration": 300,       // seconds
    "defaultTimeframe": "4h"
  }
}
```

### Supported Data Sources

- **CoinGecko**: Free, comprehensive
- **Binance**: Real-time exchange data
- **CoinMarketCap**: Professional tier available

See [CONFIGURATION.md](references/CONFIGURATION.md) for details.

## Troubleshooting

### Common Issues

#### "Pair not found"
- Check the pair format: `SYMBOL-USDT`
- See [SUPPORTED_PAIRS.md](references/SUPPORTED_PAIRS.md) for full list
- Try common alternatives (e.g., BTC instead of BTC-USDT)

#### "No data available"
- Check internet connection
- Verify API is accessible
- Try different data source

#### "Price seems wrong"
- Data may be delayed (check timestamp)
- Different exchanges have different prices
- Consider using multiple sources

### Error Messages

**"Invalid pair format"**
- Use format: `SYMBOL-USDT` (e.g., BTC-USDT)

**"API rate limit exceeded"**
- Wait a moment and try again
- Consider using a different data source

**"Network timeout"**
- Check your internet connection
- Try again in a few seconds

## Best Practices

### For Traders

1. **Combine with other indicators**
   - Use RSI, MACD, Bollinger Bands
   - Consider volume profile
   - Watch for chart patterns

2. **Risk management**
   - Set stop-loss below support
   - Take profit near resistance
   - Risk no more than 1-2% per trade

3. **Time frame alignment**
   - Check multiple time frames
   - Look for confluence
   - Avoid counter-trend trades

### For Investors

1. **Long-term perspective**
   - Focus on weekly/monthly levels
   - Consider dollar-cost averaging
   - Don't time the market

2. **Portfolio management**
   - Diversify across coins
   - Rebalance periodically
   - Keep emergency fund

## References

### Technical Analysis
- [SUPPORTED_PAIRS.md](references/SUPPORTED_PAIRS.md) - Full list of supported pairs
- [CONFIGURATION.md](references/CONFIGURATION.md) - Configuration options
- [TECHNICAL_GUIDE.md](references/TECHNICAL_GUIDE.md) - Detailed methodology

### External Resources
- [Investopedia - Support and Resistance](https://www.investopedia.com/terms/s/support.asp)
- [BabyPips - Technical Analysis](https://www.babypips.com/learn/forex)
- [TradingView - Chart Patterns](https://www.tradingview.com/chart-patterns/)

## Legal Disclaimer

**Important**: This skill is for educational purposes only. It does not constitute financial advice, investment recommendation, or trading strategy. Cryptocurrency trading involves substantial risk of loss. Past performance is not indicative of future results. Always consult with a qualified financial advisor before making investment decisions.

By using this skill, you acknowledge that you understand these risks and agree to hold the skill provider harmless for any losses incurred.
