# Crypto Levels Analyzer

一个用于分析加密货币支撑位和压力位的 OpenClaw 技能。输入如 `BTC-USDT` 即可获取当前价格、关键支撑位、压力位和技术分析。

## 🚀 快速开始

### 基本用法

直接询问任何加密货币对：

```
BTC-USDT 支撑位压力位
ETH-USDT 技术分析
SOL-USDT 当前价格和关键水平
```

### 示例输出

```
📊 BTC-USDT 技术分析

💰 当前价格: $67,500
📈 24h变化: +2.5%

🔴 压力位 (Resistance):
• R1: $68,200 (近期高点)
• R2: $69,500 (心理关口)
• R3: $71,000 (历史阻力)

🟢 支撑位 (Support):
• S1: $66,800 (日内低点)
• S2: $65,500 (MA50)
• S3: $64,000 (强支撑)

📊 技术指标:
• RSI: 62 (中性偏强)
• MA50: $66,500 (支撑)
• MA100: $65,200 (支撑)

💡 交易建议: 短期看涨，关注$68,200突破
```

## 📦 安装

### 从 ClawHub 安装

```bash
clawhub install crypto-levels
```

### 手动安装

```bash
cd ~/.openclaw/skills
git clone <repo-url> crypto-levels
```

## 🎯 功能特性

### 核心功能

- ✅ **实时价格**: 获取当前市场价格
- ✅ **支撑位分析**: 识别关键买入区域
- ✅ **压力位分析**: 识别关键卖出区域
- ✅ **技术指标**: RSI, 移动平均线
- ✅ **多币种支持**: 100+ 加密货币
- ✅ **中文支持**: 完整的中文界面

### 技术分析

- **价格行为**: 近期高低点分析
- **移动平均线**: MA50, MA100, MA200
- **RSI指标**: 超买超卖判断
- **斐波那契**: 回撤和扩展水平
- **成交量分析**: 量价关系

## 📊 支持的币种

### 主要加密货币

| 代码 | 名称 | 示例查询 |
|------|------|----------|
| BTC | Bitcoin | `BTC-USDT 支撑位` |
| ETH | Ethereum | `ETH-USDT 技术分析` |
| SOL | Solana | `SOL-USDT 关键水平` |
| BNB | Binance Coin | `BNB-USDT 当前价格` |
| XRP | Ripple | `XRP-USDT 压力位` |
| ADA | Cardano | `ADA-USDT 支撑位` |
| DOGE | Dogecoin | `DOGE-USDT 分析` |
| DOT | Polkadot | `DOT-USDT 技术面` |

### 完整列表

查看 [SUPPORTED_PAIRS.md](references/SUPPORTED_PAIRS.md) 获取完整支持的币种列表。

## 🔧 使用示例

### 基础查询

```
BTC-USDT 支撑位压力位
```

### 详细分析

```
ETH-USDT 详细技术分析
```

### 多币种查询

```
BTC, ETH, SOL 的支撑位
```

### 中文查询

```
比特币 支撑位
以太坊 技术分析
```

## 📚 技术指标说明

### RSI (相对强弱指数)

- **> 70**: 超买区域（可能回调）
- **< 30**: 超卖区域（可能反弹）
- **30-70**: 中性区域

### 移动平均线

- **MA50**: 短期趋势
- **MA100**: 中期趋势
- **MA200**: 长期趋势

### 支撑位 (Support)

- 价格下跌时可能遇到的买入区域
- 多次测试未破的低点
- 成交量放大的价格区间

### 压力位 (Resistance)

- 价格上涨时可能遇到的卖出区域
- 多次测试未过的高点
- 成交量放大的价格区间

## ⚙️ 配置

### 数据源配置

技能支持多个数据源：

1. **CoinGecko** (默认) - 免费，覆盖广泛
2. **Binance** - 实时交易所数据
3. **CoinMarketCap** - 专业数据

配置文件：`/home/openclaw/.openclaw/openclaw.json`

```json
{
  "crypto-levels": {
    "enabled": true,
    "dataSource": "coingecko",
    "updateInterval": 60,
    "cacheDuration": 300,
    "defaultTimeframe": "4h"
  }
}
```

详见 [CONFIGURATION.md](references/CONFIGURATION.md)

## 🛠️ 脚本说明

### analyze_levels.py

主分析脚本，提供核心功能：

```bash
python3 scripts/analyze_levels.py BTC-USDT
```

### test_analyzer.py

测试脚本，验证多个币种：

```bash
python3 scripts/test_analyzer.py
```

### package_skill.py

打包技能用于发布：

```bash
python3 scripts/package_skill.py .
```

## 📈 使用场景

### 交易决策

- **入场时机**: 等待支撑位附近买入
- **出场时机**: 接近压力位卖出
- **止损设置**: 放在支撑位下方

### 风险管理

- **仓位控制**: 根据支撑位距离设置
- **止盈策略**: 多个压力位分批止盈
- **止损策略**: 关键支撑位下方

### 市场分析

- **趋势判断**: 通过支撑压力位
- **突破确认**: 成交量配合
- **反转信号**: 支撑压力位转换

## ⚠️ 风险提示

### 重要声明

**本技能不构成投资建议。** 所有分析仅供参考，加密货币交易存在极高风险。

### 交易风险

- **市场波动**: 加密货币价格波动剧烈
- **流动性风险**: 低流动性可能导致滑点
- **监管风险**: 政策变化可能影响价格
- **技术风险**: 系统故障、交易所问题

### 推荐做法

1. **不要投入超过承受能力的资金**
2. **使用止损订单控制风险**
3. **分散投资，不要全仓一个币种**
4. **做好自己的研究 (DYOR)**
5. **考虑专业财务建议**

## 🔒 安全建议

### API 使用

- **保护 API 密钥**: 不要泄露
- **使用环境变量**: 避免硬编码
- **定期轮换密钥**: 增强安全性
- **限制 IP 访问**: 减少风险

### 资金安全

- **使用硬件钱包**: 存储大额资金
- **启用双因素认证**: 保护交易所账户
- **警惕钓鱼**: 不要点击可疑链接
- **验证地址**: 转账前仔细检查

## 🐛 常见问题

### "Pair not found"

**原因**: 币种代码错误或不支持

**解决**:
- 检查代码是否正确（如 BTC-USDT）
- 查看 [SUPPORTED_PAIRS.md](references/SUPPORTED_PAIRS.md)
- 使用常见代码（BTC, ETH, SOL 等）

### "No data available"

**原因**: 网络问题或 API 限制

**解决**:
- 检查网络连接
- 等待几秒后重试
- 尝试不同数据源

### "Price seems wrong"

**原因**: 数据延迟或不同交易所价格差异

**解决**:
- 数据可能有延迟（检查时间戳）
- 不同交易所价格不同
- 考虑使用多个数据源

## 📊 性能优化

### 缓存策略

- **短缓存**: 60秒（快速更新）
- **中缓存**: 300秒（平衡）
- **长缓存**: 1800秒（减少 API 调用）

### 更新频率

- **高频交易**: 30秒
- **普通使用**: 60秒
- **长期投资**: 300秒

## 🎓 学习资源

### 技术分析

- [Investopedia - Support and Resistance](https://www.investopedia.com/terms/s/support.asp)
- [BabyPips - Technical Analysis](https://www.babypips.com/learn/forex)
- [TradingView - Chart Patterns](https://www.tradingview.com/chart-patterns/)

### 加密货币

- [CoinGecko](https://www.coingecko.com/)
- [Binance Academy](https://academy.binance.com/)
- [CoinMarketCap](https://coinmarketcap.com/)

## 📞 支持

### 问题反馈

- 检查 [TROUBLESHOOTING.md](references/TROUBLESHOOTING.md)
- 查看 [CONFIGURATION.md](references/CONFIGURATION.md)
- 参考 [TECHNICAL_GUIDE.md](references/TECHNICAL_GUIDE.md)

### 社区资源

- OpenClaw 社区论坛
- 加密货币交易群组
- 技术分析讨论区

## 📄 许可证

MIT License - 详见 LICENSE 文件

## 🙏 贡献

欢迎贡献！请：

1. 阅读本 README
2. 遵循代码风格
3. 添加测试用例
4. 更新文档

## 🎯 下一步计划

### 短期（1-2 个月）

- [ ] 添加更多技术指标（MACD, Bollinger Bands）
- [ ] 支持更多币种
- [ ] 优化数据源切换

### 中期（3-6 个月）

- [ ] 添加图表生成功能
- [ ] 支持自定义时间框架
- [ ] 集成更多数据源

### 长期（6-12 个月）

- [ ] 机器学习预测
- [ ] 实时交易信号
- [ ] 高级风险分析

---

**最后更新**: 2026-02-05  
**版本**: 1.0.0  
**状态**: 🟢 开发中
