# Crypto Levels Analyzer - 快速参考

## 🚀 快速命令

### 基本使用
```bash
# 快速分析 (推荐)
python3 scripts/analyze_quick.py SOL 177.70 2.31 60

# 手动输入 (交互式)
python3 scripts/analyze_manual.py SOL-USDT

# 模拟数据 (测试)
python3 scripts/mock_analyzer.py SOL-USDT
```

### 常用币种示例

#### BTC-USDT
```bash
python3 scripts/analyze_quick.py BTC 67500 -0.5 58
```

#### ETH-USDT
```bash
python3 scripts/analyze_quick.py ETH 3450 1.2 62
```

#### SOL-USDT
```bash
python3 scripts/analyze_quick.py SOL 177.70 2.31 60
```

#### BNB-USDT
```bash
python3 scripts/analyze_quick.py BNB 580 0.8 55
```

#### XRP-USDT
```bash
python3 scripts/analyze_quick.py XRP 0.52 -1.5 45
```

## 📊 常用价格参考 (2026-02-05)

| 币种 | 代码 | 参考价格 (USD) | 24h变化 | RSI |
|------|------|----------------|---------|-----|
| Bitcoin | BTC | $67,500 | -0.5% | 58 |
| Ethereum | ETH | $3,450 | +1.2% | 62 |
| Solana | SOL | $177.70 | +2.31% | 60 |
| Binance Coin | BNB | $580 | +0.8% | 55 |
| Ripple | XRP | $0.52 | -1.5% | 45 |
| Cardano | ADA | $0.48 | +0.5% | 52 |
| Dogecoin | DOGE | $0.085 | +3.2% | 65 |
| Polkadot | DOT | $7.20 | -0.8% | 48 |
| Avalanche | AVAX | $35.50 | +1.5% | 58 |
| Polygon | MATIC | $0.58 | +0.3% | 53 |

## 🎯 分析结果解读

### 支撑位 (Support)
- **S1**: 近期支撑 (3% 下跌)
- **S2**: 中期支撑 (5% 下跌)
- **S3**: 强支撑 (8% 下跌)

**使用方法**:
- 价格接近支撑位时考虑买入
- 设置止损在支撑位下方
- 多次测试未破的支撑更强

### 压力位 (Resistance)
- **R1**: 近期压力 (3% 上涨)
- **R2**: 中期压力 (5% 上涨)
- **R3**: 强压力 (8% 上涨)

**使用方法**:
- 价格接近压力位时考虑卖出
- 突破压力位可能开启新上涨空间
- 多次测试未过的压力更强

### 技术指标

#### RSI (相对强弱指数)
- **< 30**: 超卖 (可能反弹)
- **30-70**: 中性
- **> 70**: 超买 (可能回调)

#### MA50 (50周期移动平均线)
- **价格 > MA50**: 短期上涨趋势，MA50 是支撑
- **价格 < MA50**: 短期下跌趋势，MA50 是阻力

#### MA100 (100周期移动平均线)
- **价格 > MA100**: 中期上涨趋势，MA100 是支撑
- **价格 < MA100**: 中期下跌趋势，MA100 是阻力

## 💡 交易决策流程

### 1. 获取数据
```bash
# 访问交易所获取当前价格
# 例如: SOL-USDT = $177.70

# 计算24h变化
# (177.70 - 173.70) / 173.70 * 100 = 2.31%

# 获取RSI (可选)
# 从TradingView或交易所获取，或使用默认值55
```

### 2. 运行分析
```bash
python3 scripts/analyze_quick.py SOL 177.70 2.31 60
```

### 3. 解读结果

#### 买入信号
- ✅ RSI < 30 (超卖)
- ✅ 价格接近支撑位 (S1, S2, S3)
- ✅ MA50 是支撑
- ✅ 24h变化为负但幅度小

#### 卖出信号
- ✅ RSI > 70 (超买)
- ✅ 价格接近压力位 (R1, R2, R3)
- ✅ MA50 是阻力
- ✅ 24h变化为正但幅度大

### 4. 制定计划

#### 买入计划
```
入场: $174 (MA50附近)
止损: $172 (S1下方)
止盈: $183 (R1)
风险: $2 (1.1%)
回报: $9 (5.2%)
风险回报比: 1:4.5
```

#### 卖出计划
```
入场: $183 (R1附近)
止损: $185 (上方2%)
止盈: $172 (S1)
风险: $2 (1.1%)
回报: $11 (6.0%)
风险回报比: 1:5.5
```

## 📈 风险管理

### 仓位计算
```python
# 公式: 仓位大小 = 风险金额 / (入场价 - 止损价)

# 示例:
# 总资金: $10,000
# 单笔风险: 2% = $200
# 入场价: $174
# 止损价: $172
# 仓位大小: $200 / ($174 - $172) = 100 SOL
```

### 止损策略
- **短线**: 支撑位下方 1-2%
- **中线**: 支撑位下方 3-5%
- **长线**: 支撑位下方 5-10%

### 止盈策略
- **保守**: R1 (30%), R2 (30%), R3 (40%)
- **激进**: R2 (50%), R3 (50%)
- **追踪**: 随价格上涨移动止损

## 🔧 常见问题

### Q: 如何获取当前价格？
**A**: 访问交易所网站或App，如 Binance、OKX、Coinbase

### Q: 如何计算24h变化？
**A**: `(当前价 - 24小时前价) / 24小时前价 * 100`

### Q: 如何获取RSI？
**A**: 
1. 访问 TradingView
2. 搜索币种 (如 SOLUSDT)
3. 添加RSI指标
4. 查看当前值

### Q: 网络无法访问怎么办？
**A**: 使用手动或快速模式，手动输入价格数据

### Q: 分析结果不准确？
**A**: 
- 使用最新价格数据
- 结合多个时间框架
- 关注市场新闻
- 降低仓位风险

## 📚 进阶技巧

### 多时间框架分析
```bash
# 短线 (1H, 4H)
python3 scripts/analyze_quick.py SOL 177.70 2.31 60

# 中线 (4H, 1D)
python3 scripts/analyze_quick.py SOL 177.70 2.31 60

# 长线 (1D, 1W)
python3 scripts/analyze_quick.py SOL 177.70 2.31 60
```

### 结合成交量
- **高成交量 + 支撑位**: 强支撑
- **高成交量 + 压力位**: 强压力
- **低成交量**: 弱水平，易突破

### 市场情绪
- **贪婪**: RSI > 70, 大幅上涨
- **恐惧**: RSI < 30, 大幅下跌
- **中性**: RSI 40-60, 小幅波动

## ⚠️ 重要提醒

### 风险提示
1. **加密货币风险极高** - 价格可能快速波动
2. **不要投入超过承受能力的资金**
3. **做好自己的研究 (DYOR)**
4. **这不是投资建议**

### 最佳实践
1. **从小额开始** - 熟悉后再增加仓位
2. **设置止损** - 保护本金最重要
3. **分散投资** - 不要全仓一个币种
4. **持续学习** - 提升分析能力

## 📞 获取帮助

### 文档
- **快速参考**: [QUICK_REFERENCE.md](QUICK_REFERENCE.md) (本文件)
- **快速开始**: [QUICKSTART.md](QUICKSTART.md)
- **完整说明**: [README.md](README.md)
- **使用指南**: [USAGE_GUIDE.md](USAGE_GUIDE.md)

### 技术文档
- **技术指南**: [references/TECHNICAL_GUIDE.md](references/TECHNICAL_GUIDE.md)
- **配置说明**: [references/CONFIGURATION.md](references/CONFIGURATION.md)
- **币种列表**: [references/SUPPORTED_PAIRS.md](references/SUPPORTED_PAIRS.md)

---

**最后更新**: 2026-02-05  
**版本**: 1.0.2  
**状态**: 🟢 稳定版
