---
name: crypto-learning
description: 加密货币自学系统。每天早上9点自动推送学习内容；每次调用都必须产出小白友好、可直接学习的详细报告（不是只给标题），并通过 web_search 检索并整合最新资料。包含完整学习大纲（小白向、投资向、进阶投资三个阶段），支持进度跟踪、跳过与重置。
---

# Crypto Learning - 加密货币自学系统

## 目标

给 hmzo 提供“每天可直接学习”的加密货币课程推送：
- 解释清楚（小白能看懂）
- 内容完整（不是只有题目）
- 有最新资料整合（web_search 检索）
- 有可执行学习动作（自测/作业）

## 学习大纲位置

学习大纲在 `content.json`：
- 小白向（30天）
- 投资向（60天）
- 进阶投资（90天）

进度在 `progress.json`。

## 必须遵守的输出质量规则（硬约束）

每次输出学习报告都必须满足以下要求：

1. **禁止只输出题目或一句话摘要**。
2. **最少包含 6 个模块**（见下方固定模板）。
3. **正文长度不少于 450 字**（不含标题与分隔符）。
4. **术语必须解释**：首次出现术语（如 PoW、PoS、Gas、TVL）时，给一句“白话解释”。
5. **至少给 2 个生活类比或场景例子**，帮助理解抽象概念。
6. **至少给 3 条要点总结**（可背诵版本）。
7. **必须含 3 道自测题 + 标准答案**。
8. **最后给出次日预告**，并更新学习进度。

若 web_search 检索结果不足，仍要基于 `content.json` 产出完整报告，不得降级为短消息。

## 固定输出模板（每次都用）

按以下结构输出（允许微调措辞，但模块不可缺失）：

1. `📚 第 X 天学习内容`（阶段 / 主题 / 今日重点）
2. `📖 先讲人话版`（先用 3-6 句白话解释核心概念）
3. `🧱 系统化知识`（定义、原理、关键组成、常见误区）
4. `🌐 最新资料整合`（基于 web_search 的信息融合，不要贴生硬链接堆砌）
5. `🧠 例子与类比`（至少 2 个）
6. `✅ 今日小结`（至少 3 条可记忆要点）
7. `📝 3题自测（含答案）`
8. `🚀 明日预告 + 进度更新`

## 工作流程

### 1) 读取进度

读取 `progress.json`：
- `current_stage`
- `current_topic_index`
- `current_subtopic_index`
- `completed_subtopics`

### 2) 获取今日主题

根据进度从 `content.json` 取出：
- 阶段
- 主题
- 子主题
- 基础知识点

### 3) web_search 检索并整合

必须检索当日主题相关的最新内容，再进行融合输出。

检索建议：
- 中文关键词：`子主题 + 加密货币 + 入门/教程/原理`
- 英文关键词：`subtopic + crypto + beginner guide/explained`
- 优先权威来源：Binance Academy、CoinMarketCap Alexandria、Investopedia、Ethereum/Bitcoin 官方文档等

要求：
- 不照搬原文；用自己的结构重写
- 把多来源信息合并成统一叙事
- 说明“共识点”和“容易误解点”

### 4) 生成详细学习报告

严格使用“固定输出模板”，并满足“硬约束”。

### 5) 更新进度

完成后更新 `progress.json`：
- 标记当前子主题完成
- 指向下一个子主题
- 更新 `last_push_date`
- `total_days_completed +1`

## 用户命令

### 开始学习计划
按当前进度继续推送。

### 查看进度
显示：已完成天数、当前阶段/主题、已完成知识点。

### 跳过今天
记录跳过日期，不推进学习内容。

### 重置计划
清空进度并从第一个主题开始。

### 手动学习某个主题
支持临时学习指定主题；默认不改自动进度（除非用户明确要求）。

## 失败降级策略

- web_search 失败：改用 `content.json` + 已有常识生成完整详细版，不得只发标题。
- 信息冲突：优先通用共识，标注“不同平台口径可能不同”。
- 内容过深：自动加“白话翻译”段，确保小白可读。

## 风格要求

- 默认中文，语气亲切但不废话。
- 先白话后术语，先结论后展开。
- 以“能学会”为目标，不写成新闻快讯。
- 每次都要让用户“看完就有收获”。
