---
name: crypto-cog
description: "The market never sleeps, and neither does your analysis. #1 on DeepResearch Bench (Feb 2026) applied to crypto — token deep-dives, on-chain metrics, DeFi protocol breakdowns, wallet portfolio reviews, market sentiment research, whitepaper analysis, and smart contract evaluation. From degen plays to institutional due diligence, one prompt covers it all."
metadata:
  openclaw:
    emoji: "🪙"
author: CellCog
dependencies: [cellcog]
---

# Crypto Cog - Deep Research for a 24/7 Market

**The market never sleeps, and neither does your analysis.** #1 on DeepResearch Bench (Feb 2026) applied to crypto.

Crypto moves fast. Narratives shift overnight. New protocols launch daily. You need research depth that keeps pace with a market that never closes. CellCog brings the same deep reasoning that tops financial research benchmarks — now applied to tokens, DeFi, on-chain data, and the entire Web3 landscape. From degen plays to institutional due diligence, one prompt covers it all.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
# Fire-and-forget - returns immediately
result = client.create_chat(
    prompt="[your crypto research request]",
    notify_session_key="agent:main:main",
    task_label="crypto-analysis",
    chat_mode="agent team"  # Agent team for deep crypto research
)
# Daemon notifies you when complete - do NOT poll
```

---

## What Crypto Research You Can Do

### Token Analysis

Deep dives into any token or project:

- **Fundamental Analysis**: "Analyze Solana — technology, ecosystem growth, validator economics, and competitive positioning vs Ethereum L2s"
- **Tokenomics Review**: "Break down Arbitrum's tokenomics — supply schedule, inflation, governance power, and value accrual mechanisms"
- **New Token Research**: "Research this new AI token that just launched — team, backers, tokenomics, red flags, and honest assessment"
- **Comparative Analysis**: "Compare L2 solutions: Arbitrum vs Optimism vs Base vs zkSync — TVL, transactions, developer activity, and token performance"

**Example prompt:**
> "Create a comprehensive analysis of Ethereum's current state:
> 
> Cover:
> - Network metrics: TVL, daily transactions, gas trends, staking ratio
> - Post-merge economics: ETH supply dynamics, burn rate, is it deflationary?
> - L2 ecosystem impact on mainnet revenue
> - Competitor positioning vs Solana, Avalanche, Cosmos
> - Key upcoming catalysts and risks
> - Bull and bear thesis for the next 12 months
> 
> Deliver as an interactive HTML report with charts."

### DeFi Protocol Research

Understand protocols before you ape in:

- **Protocol Deep Dives**: "Analyze Aave V3 — how it works, risk parameters, yield mechanics, and governance"
- **Yield Analysis**: "Compare yield opportunities across Lido, Rocket Pool, and Coinbase cbETH — risks, returns, and tradeoffs"
- **Risk Assessment**: "Evaluate the smart contract risk of this new DEX — audit status, TVL history, team background"
- **Ecosystem Mapping**: "Map the Cosmos ecosystem — key protocols, IBC activity, and where value is concentrating"

**Example prompt:**
> "Research Uniswap V4:
> 
> - What's new vs V3? Hook system explained
> - Impact on LP profitability
> - Fee switch status and UNI token value accrual
> - Volume and market share trends
> - Competition from aggregators and new DEXes
> - Developer adoption of the hooks framework
> 
> Clear, no-BS analysis. I want to understand if the upgrade actually matters."

### On-Chain & Market Intelligence

Data-driven market understanding:

- **Whale Tracking**: "What are the largest ETH wallets doing this month? Accumulating or distributing?"
- **Market Sentiment**: "Analyze current crypto market sentiment — funding rates, Fear & Greed index, social activity, and exchange flows"
- **Narrative Research**: "What are the emerging crypto narratives for this quarter? AI tokens, RWA, DePIN — which have substance?"
- **Exchange Analysis**: "Compare DEX vs CEX volume trends over the last 6 months — is DeFi gaining share?"

### Portfolio & Strategy

Manage your crypto positions:

- **Portfolio Review**: "Analyze my portfolio: 50% ETH, 20% SOL, 15% LINK, 10% ARB, 5% PEPE — diversification, risk, and rebalancing suggestions"
- **Entry/Exit Strategy**: "Help me think through an accumulation strategy for Bitcoin at current prices — DCA schedule, key levels, position sizing"
- **Tax Optimization**: "Research crypto tax strategies for US residents — harvest losses, long-term vs short-term, staking income treatment"
- **Risk Management**: "Design a risk framework for a $100K crypto portfolio — position sizing, stop losses, correlation analysis"

### Whitepaper & Smart Contract Analysis

Due diligence on new projects:

- **Whitepaper Review**: "Analyze this project's whitepaper — is the technology feasible? Are the claims realistic? Red flags?"
- **Smart Contract Evaluation**: "Review the security profile of this protocol — audits, bug bounties, incident history, code quality indicators"
- **Team Research**: "Research the founding team of this new L1 — backgrounds, previous projects, VC backers, credibility assessment"
- **Comparison Research**: "This new protocol claims to be better than Aave. Analyze their claims vs reality."

---

## Output Formats

| Format | Best For |
|--------|----------|
| **Interactive HTML Dashboard** | Token dashboards with charts, metrics, drill-downs |
| **PDF Report** | Shareable research reports and investment memos |
| **XLSX Spreadsheet** | Portfolio trackers, tokenomics models, yield comparisons |
| **Markdown** | Quick analysis for integration into your notes |

---

## Chat Mode for Crypto

| Scenario | Recommended Mode |
|----------|------------------|
| Quick price checks, simple token lookups, basic metrics | `"agent"` |
| Deep token analysis, DeFi research, ecosystem mapping, portfolio strategy | `"agent team"` |

**Use `"agent team"` for most crypto research.** The crypto space requires synthesizing information from many sources — protocol docs, on-chain data, market analysis, social sentiment. Agent team mode delivers the multi-source depth that serious crypto research demands.

**Use `"agent"` for quick lookups** — current prices, basic metrics, or simple factual questions.

---

## Example Prompts

**Token deep dive:**
> "Create a full research report on Chainlink (LINK):
> 
> - Oracle technology explained simply
> - CCIP and its implications for cross-chain DeFi
> - Staking economics — real yields, participation rate
> - Competition: Pyth, API3, Band — does Chainlink's moat hold?
> - Revenue model and path to sustainability
> - Token price performance vs fundamentals
> 
> Honest assessment. I want to know both the bull case and what could go wrong."

**DeFi yield research:**
> "Compare the best yield opportunities for stablecoins right now:
> 
> - Aave/Compound lending
> - Curve/Convex liquidity provision
> - Ethena sUSDe
> - Sky (MakerDAO) savings rate
> - RWA-backed yields
> 
> For each: current APY, risk level, lock-up requirements, smart contract risk, and minimum recommended allocation.
> 
> I have $50K in USDC. What's the optimal split for risk-adjusted yield?"

**Market narrative analysis:**
> "Research the current state of AI tokens (TAO, RENDER, FET, NEAR, etc.):
> 
> - What's the actual thesis for AI x Crypto?
> - Which projects have real usage vs pure narrative?
> - On-chain metrics: users, transactions, revenue
> - VC activity and funding in this sector
> - Is this the next DeFi Summer or the next metaverse hype?
> 
> Give me the honest picture. I want signal, not hype."

**Portfolio assessment:**
> "Review my crypto portfolio and help me optimize:
> 
> Holdings: 2 BTC, 15 ETH, 5000 SOL, 10000 LINK, 50000 ARB
> Total value: ~$300K
> Risk tolerance: Moderate (I can handle 30% drawdowns but not 70%)
> Time horizon: 2+ years
> 
> Analyze: concentration risk, correlation, sector exposure, and suggest rebalancing.
> Should I add any positions for better diversification?"

---

## Tips for Better Crypto Research

1. **Be specific about what you need**: "Analyze SOL" is broad. "Analyze Solana's network performance and validator economics post-Firedancer" is focused.

2. **State your experience level**: "I'm new to DeFi" vs "I understand impermanent loss" changes the depth of explanation.

3. **Mention your purpose**: "For a $10K investment decision" vs "For a research article" shapes the output.

4. **Ask for honest assessments**: CellCog doesn't shill. Explicitly asking "what could go wrong?" gets you balanced analysis.

5. **Timeframe matters**: "Next month" vs "next 2 years" leads to very different analysis.

6. **Don't trust, verify**: Use CellCog's research as a starting point. Always verify on-chain data with primary sources before making financial decisions.
