# Crypto Wallets & Payments for AI Agents

Create wallets, transfer tokens, and enable payments between agents. Perfect for bug bounty programs, rewards systems, and agent-to-agent transactions.

## What This Enables

- **Create wallets** - Generate ERC20-compatible wallets with secure key storage
- **Transfer tokens** - Send ETH, USDC, or any ERC20 token to any address
- **Swap tokens** - Exchange tokens across 13 chains with best rates
- **Earn referrer fees** - Get 80% of extra swap fees by referring users
- **Agent payments** - Bug bounties, rewards programs, automated payouts

## MCP Server Setup

For Moltbot/OpenClaw, configure via mcporter:
```bash
mcporter config add onlyswaps --command "npx -y @onlyswaps/mcp-server@latest stdio" --transport stdio
```

For Claude Desktop, add to MCP config:
```json
{
  "mcpServers": {
    "onlyswaps": {
      "command": "npx",
      "args": ["-y", "@onlyswaps/mcp-server@latest", "stdio"]
    }
  }
}
```

## Available Tools

### Read-Only (no wallet needed)
| Tool | Description |
|------|-------------|
| `get_quote` | Get swap quotes from 15+ DEX aggregators |
| `get_portfolio` | View token balances for any address |

### Wallet Required (need PRIVATE_KEY)
| Tool | Description |
|------|-------------|
| `setup_wallet` | Create a new wallet (saves PRIVATE_KEY to .env) |
| `check_setup` | Verify wallet config and balances |
| `transfer` | Send tokens to any address |
| `swap` | Execute token swaps (with optional referrer fees) |
| `approve_permit2` | Approve tokens for gasless swaps |

## Earn Fees as a Referrer

AI agents can earn fees by setting `referrerAddress` and `extraFeeBps` on swaps:

| extraFeeBps | Referrer Gets | OnlySwaps Gets | Total User Fee |
|-------------|---------------|----------------|----------------|
| 0 (default) | 0 bps | 20 bps | 0.20% |
| 10 (suggested) | 8 bps | 22 bps | 0.30% |
| 100 (max) | 80 bps | 40 bps | 1.20% |

**Example:** With `extraFeeBps: 10`, on a $1000 swap:
- Referrer earns: $0.80 (8 bps)
- User pays: $3 total (0.30%)

**Note:** Referrer fees only work for ERC20 swaps. Native token swaps (ETH, BNB) don't support referrer fees.

## IMPORTANT: Private Key Handling

**For wallet operations, you MUST have PRIVATE_KEY set.**

If the user wants to create a wallet, transfer, or swap:
1. First ask: "Do you have an existing wallet private key, or should I create a new one?"
2. If new: Use `setup_wallet` to generate one
3. If existing: Ask user to provide PRIVATE_KEY and set it in environment

To call tools with PRIVATE_KEY:
```bash
PRIVATE_KEY=0x... mcporter call onlyswaps.check_setup chainId=8453
```

## Amount Format

**Different tools use different formats:**

| Tool | Format | Example |
|------|--------|---------|
| `get_quote` | wei (base units) | `"1000000000000000"` = 0.001 ETH |
| `swap` | wei (base units) | `"100000000000000000"` = 0.1 ETH |
| `transfer` | human readable | `"0.001"` = 0.001 tokens |

**Wei conversion:**
- 1 ETH = `1000000000000000000` (18 zeros)
- 0.001 ETH = `1000000000000000` (15 zeros)
- 1 USDC = `1000000` (6 decimals)

## Quick Examples

**IMPORTANT: Use function call syntax with quoted strings!**

### Get a swap quote (no wallet needed)
```bash
mcporter call 'onlyswaps.get_quote(fromToken: "0xEeeeeEeeeEeEeeEeEeEeeEEEeeeeEeeeeeeeEEeE", toToken: "0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913", amount: "1000000000000000", chainId: 8453)'
```

### Check any address portfolio (no wallet needed)
```bash
mcporter call 'onlyswaps.get_portfolio(userAddress: "0xd8dA6BF26964aF9D7eEd9e03E53415D37aA96045")'
```

### Create a new wallet
```bash
mcporter call onlyswaps.setup_wallet
# Returns: address and private key - SAVE THE PRIVATE KEY!
```

### Check wallet setup (requires PRIVATE_KEY)
```bash
PRIVATE_KEY=0x... mcporter call 'onlyswaps.check_setup(chainId: 8453)'
```

### Transfer tokens (requires PRIVATE_KEY + funded wallet)
```bash
PRIVATE_KEY=0x... mcporter call 'onlyswaps.transfer(tokenAddress: "0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913", toAddress: "0xRecipientAddress", amount: "1000000", chainId: 8453)'
```

### Swap with referrer fee (earn fees as an agent)
```bash
PRIVATE_KEY=0x... mcporter call 'onlyswaps.swap(fromToken: "0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913", toToken: "ETH", amount: "100000000", chainId: 8453, referrerAddress: "0xYourAgentWallet", extraFeeBps: 10)'
```

## Supported Chains

| Chain | ID | Native Token |
|-------|-----|--------------|
| Ethereum | 1 | ETH |
| Base | 8453 | ETH |
| Arbitrum | 42161 | ETH |
| Optimism | 10 | ETH |
| Polygon | 137 | MATIC |
| BNB Chain | 56 | BNB |
| Avalanche | 43114 | AVAX |

## Common Token Addresses

| Token | Base (8453) | Ethereum (1) |
|-------|-------------|--------------|
| Native (ETH) | 0xEeeeeEeeeEeEeeEeEeEeeEEEeeeeEeeeeeeeEEeE | 0xEeeeeEeeeEeEeeEeEeEeeEEEeeeeEeeeeeeeEEeE |
| USDC | 0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913 | 0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48 |

## Security Notes

- Private keys are stored locally, never transmitted
- Always verify addresses before sending
- Start with small test amounts

## Links

- **npm**: [@onlyswaps/mcp-server](https://www.npmjs.com/package/@onlyswaps/mcp-server)
- **Docs**: [onlyswaps.fyi](https://onlyswaps.fyi)

---

Built by [OnlySwaps](https://onlyswaps.fyi) 🦞
