---
name: crs-report-generator
description: 从银行/券商PDF流水自动提取信息，生成美化的CRS金融账户信息申报表。支持PDF解析、数据提取、表格生成。
emoji: 📊
category: tools
tags: [crs, tax, report, finance, excel, pdf]
author: OpenClaw
version: 2.0.0
---

# CRS 申报表生成工具

从银行/券商的PDF流水（、月结单、资产报告等）自动提取信息，生成符合CRS标准的金融账户信息申报表。

## 功能

- 📄 **PDF解析** - 自动从PDF提取客户信息、账户信息、交易记录
- 📊 **表格生成** - 生成专业美化的Excel表格
- 👤 **信息脱敏** - 自动去除敏感信息，只保留模板
- 💰 **多币种支持** - HKD、USD、CNH、JPY等

## 使用场景

1. 客户有海外银行/券商账户
2. 需要做CRS申报
3. 从券商获取月度账单/PDF流水
4. 生成标准申报表格

## 使用方法

### 1. 接收PDF文件

用户上传银行/券商的PDF流水（月结单、资产报告等）

### 2. 自动提取信息

脚本会从PDF中提取：
- 客户姓名
- 账户号码
- 账户类型
- 账户余额/价值
- 交易记录
- 费用明细

### 3. 生成申报表

输出美化版Excel表格，包含：
- 账户持有人信息
- 金融机构信息
- 账户余额/价值
- 交易记录凭证
- 费用明细

## 技术栈

- Python 3.x
- pdfplumber / PyPDF2 - PDF解析
- openpyxl - Excel生成
- BeautifulSoup - 网页解析

## 示例

```
用户: 帮我处理这个券商流水生成CRS申报表
AI: 请上传PDF文件，我会自动提取信息生成CRS申报表

用户: [上传富途证券月结单PDF]
AI: 已提取以下信息:
- 客户: [姓名]
- 账户: [账号]
- 期末资产: [金额]
需要补充:
- 客户身份证号(TIN)
- 金融机构完整名称

用户: [补充缺失信息]
AI: ✅ CRS申报表已生成，已发送给你！
```

## 注意事项

1. PDF需要是文本类型（非图片扫描）
2. 部分信息可能需要人工补充
3. 生成的表格仅供参考，实际申报需专业人士审核

## 更新日志

- 2026-03-02: v2.0 美化表格样式，增加脱敏功能
- 2026-02-27: v1.0 初始版本