---
name: cross-pollination-engine
description: Systematically borrow ideas from unrelated industries to solve problems. Innovation often comes from adjacent fields. Use when user says "cross-pollination", "how would X solve this", "borrow ideas from", "what can we learn from", "think outside the box", "how would Disney/Apple/Amazon do this", "different industry", "steal ideas".
---

# Cross-Pollination Engine

## The Core Insight

Most "innovation" is applying proven solutions from one domain to another.
- Resistance wheels → Rollerblades
- Gaming XP systems → Duolingo
- Hotel concierge → Software onboarding

## The Process

1. **Define the core job** (strip away industry context)
2. **Find who else solves it** (often surprising industries)
3. **Extract principles** (not surface features)
4. **Translate to your context** (adapt, don't copy)

## Industry Inspiration Library

| Need | Look At | Why |
|------|---------|-----|
| **Trust** | Banking, Healthcare, Aviation | Verification, credentials, checklists |
| **Engagement** | Gaming, Fitness apps, Streaming | XP, streaks, personalization, progress |
| **Onboarding** | Hotels, Theme parks, Luxury retail | Concierge, anticipation, personal touch |
| **Simplicity** | Apple, IKEA, Google | Feature cutting, hidden complexity |
| **Urgency** | E-commerce, Airlines, Fast food | Scarcity, anchoring, speed promises |
| **Community** | CrossFit, Harley-Davidson, Peloton | Tribal identity, shared experience |

## Output Format

```
PROBLEM: [What you're solving]
CORE JOB: [Stripped to fundamentals]

FROM [Industry 1]:
How they solve it: [x]
Key principle: [y]
Applied to us: [z]

FROM [Industry 2]:
How they solve it: [x]
Key principle: [y]
Applied to us: [z]

SYNTHESIS: [Combined approach]
NEXT STEP: [Concrete action]
```

## Prompt Starters

- "How would Disney solve our onboarding?"
- "What would Amazon do with our data?"
- "If this were a game, how would it work?"
- "How do luxury hotels make people feel special?"

## Integration

Compounds with:
- **jtbd-analyzer** → Understand job first, then find who else solves it
- **first-principles-decomposer** → Strip context to find fundamental need
- **six-thinking-hats** → Green Hat pairs naturally with cross-pollination
- **app-planning-skill** → Apply borrowed patterns to new apps

---
See references/examples.md for Artem-specific cross-pollinations
