# Cross-Device Sync Skill

通过GitHub仓库实现OpenClaw跨设备记忆同步的技能。

## 描述

这个技能允许用户轻松地在多个设备之间同步OpenClaw的记忆文件。通过GitHub作为中央存储库，用户可以在不同的设备上访问相同的数据。

## 功能

- 自动创建跨设备同步所需的脚本
- 配置GitHub仓库访问
- 设置双向同步机制
- 提供冲突处理机制
- 自动化定时同步选项

## 安装

```bash
npx clawhub install cross-device-sync
```

## 使用方法

### 1. 初始化设置

```javascript
// 设置跨设备同步
await setup_cross_device_sync({
  repoUrl: "https://github.com/username/repository.git",
  token: "your_github_personal_access_token"
});
```

### 2. 立即同步

```javascript
// 立即执行同步
await sync_now();
```

### 3. 检查状态

```javascript
// 检查同步状态
await check_sync_status();
```

## 详细说明

### setup_cross_device_sync

此函数会引导用户完成整个设置过程：

1. 验证GitHub仓库访问权限
2. 克隆或更新本地仓库
3. 创建双向同步脚本
4. 配置OpenClaw使用同步目录
5. 创建配置文档

### sync_now

此函数执行即时双向同步：

1. 从GitHub拉取最新更改
2. 将本地更改合并到工作区
3. 将本地更改推送到GitHub

### check_sync_status

此函数检查同步系统的状态：

1. 验证GitHub仓库连接
2. 检查同步脚本是否存在
3. 检查仓库状态
4. 报告配置信息

## 安全注意事项

- 请确保GitHub仓库是私有的以保护敏感数据
- 妥善保管Personal Access Token
- 定期轮换访问令牌
- 检查同步日志以确保没有异常活动

## 故障排除

如果遇到同步问题：

1. 检查网络连接
2. 验证GitHub认证信息
3. 查看同步日志
4. 确认仓库权限

## 维护

- 定期检查同步日志
- 清理旧的备份文件
- 验证数据一致性
- 更新访问令牌