# 发布说明：Cross-Device Sync 技能

## 版本 1.0.0

### 功能特性
- 通过GitHub仓库实现OpenClaw跨设备记忆同步
- 自动创建双向同步脚本
- 支持冲突处理和数据一致性保证
- 提供状态检查功能
- 支持定时同步设置

### 使用场景
- 在多台设备间同步OpenClaw记忆文件
- 通过GitHub作为中央存储库备份数据
- 实现团队协作环境下的数据共享
- 保障重要记忆数据的安全备份

### 安装方法
```bash
npx clawhub install cross-device-sync
```

### 使用方法
1. 运行 `setup_cross_device_sync()` 开始配置
2. 输入GitHub仓库URL和Personal Access Token
3. 系统自动创建同步脚本和配置
4. 使用 `sync_now()` 进行即时同步
5. 使用 `check_sync_status()` 检查同步状态

### 安全说明
- 请确保使用私有GitHub仓库存储敏感数据
- 妥善保管Personal Access Token
- 定期轮换访问令牌

### 依赖项
- Git
- Bash环境
- GitHub账户和Personal Access Token