#!/bin/bash
# list-backups.sh - List available backups
# Usage: ./list-backups.sh <backup_dir>

BACKUP_DIR="${1:-}"

if [ -z "$BACKUP_DIR" ]; then
    echo "Usage: $0 <backup_dir>"
    exit 1
fi

if [ ! -d "$BACKUP_DIR" ]; then
    echo "Error: Directory does not exist: $BACKUP_DIR"
    exit 1
fi

echo "Available backups in: $BACKUP_DIR"
echo ""

# List backups with details
if command -v ls &> /dev/null; then
    ls -lh "$BACKUP_DIR"/*.tar.gz 2>/dev/null | awk '{printf "  %-20s %8s %s %s\n", $9, $5, $6, $7}' | sed 's/.*\///'
fi

# Summary
echo ""
COUNT=$(find "$BACKUP_DIR" -name "*.tar.gz" -type f 2>/dev/null | wc -l)
TOTAL_SIZE=$(du -sh "$BACKUP_DIR" 2>/dev/null | cut -f1 || echo "unknown")
echo "Total: $COUNT backup(s), $TOTAL_SIZE"

# Show version record if exists
if [ -f "$BACKUP_DIR/.version_record" ]; then
    echo ""
    echo "Last backed up version: $(cat "$BACKUP_DIR/.version_record")"
fi

# Show recent log entries if exists
if [ -f "$BACKUP_DIR/.backup.log" ]; then
    echo ""
    echo "Recent backup activity (last 5 entries):"
    tail -n 5 "$BACKUP_DIR/.backup.log" 2>/dev/null | sed 's/^/  /'
fi
