# Common Scenarios & Prompt Examples

## Scenario 1: Tech Industry Critique Article

**Situation:** You want to critique a new AI company's claimed capabilities vs. business viability

**Prompt to Claude:**
```
Use the critical article writer skill to draft an article about [Company]'s recent [announcement]. 

The article should:
- Open with a skeptical observation about their financial claims
- Examine what the actual data shows about [specific metric]
- Compare their model to [similar company]'s approach
- Identify the questionable assumption underneath their narrative
- Acknowledge what they might be doing right
- Close with implications for the market

Target audience: People familiar with tech/AI but not financial experts
Target length: 600-800 words
Tone: Skeptical but intellectually fair
Key evidence to include: [specific data points or sources]

Generate an outline first for approval.
```

## Scenario 2: Industry Pattern Thread

**Situation:** You've noticed the same pattern across multiple companies

**Prompt to Claude:**
```
Use the critical article writer skill to create a 6-post thread about [pattern you've noticed].

The thread should:
- Hook readers with a surprising observation
- Show the pattern across [Company A], [Company B], [Company C]
- Explain why this pattern exists
- Reveal what it means (implications)
- Address why this might actually be okay (nuance)
- Close with a provocative question for engagement

Include relevant hashtags. Each post should be self-contained but flow together.
Make it shareable and thought-provoking.

Give me the outline first so I can approve before you write the full posts.
```

## Scenario 3: Research-Backed Analysis

**Situation:** You found data that contradicts conventional wisdom

**Prompt to Claude:**
```
Use the critical article writer skill to write an article challenging the assumption that [common belief].

Evidence you found:
- [Data point 1 with source]
- [Data point 2 with source]
- [Data point 3 with source]

Article should:
- Open with the common belief
- Introduce your evidence layer by layer
- Show where the conventional wisdom breaks down
- Explain why people believe the incorrect version
- Acknowledge limitations in your analysis
- Suggest what we should actually believe instead

Target length: 700 words
Tone: "I might be wrong, but here's what the data shows"

Create an outline first for my review.
```

## Scenario 4: Quick Take Series

**Situation:** You want to generate multiple quick observations about a topic

**Prompt to Claude:**
```
Using the critical article writer skill, generate 4 quick takes (1-3 sentences each) about [topic].

Each take should:
- Be self-contained and sharpable
- Include one specific observation
- Have one surprising detail or implication
- Suggest the reader should think about [angle]
- Include a link/source reference

Make each one punchy and suitable for social media. Use hashtags.
```

## Scenario 5: Deep Dive Analysis

**Situation:** You're diving deep into a complex industry dynamic

**Prompt to Claude:**
```
Use the critical article writer skill to create a comprehensive outline for a deep dive article.

Topic: [What you're analyzing]
Thesis: [Your main argument]
Target audience: [Who this is for]
Target length: 1200-1500 words

The outline should include:
- An opening that challenges conventional wisdom
- 5 major sections with specific evidence
- A section for counterarguments
- A conclusion tying back to implications

Please generate the outline first. Then once approved, write the full article maintaining the critical, analytical voice throughout.
```

## Scenario 6: Comparing Two Approaches

**Situation:** Two companies are solving the same problem differently

**Prompt to Claude:**
```
Use the critical article writer skill to draft an article comparing [Company A]'s approach to [Company B]'s approach to [problem].

The article should:
- Explain what each company is doing
- Highlight the critical difference in their assumptions
- Show what the data reveals about which approach is more viable
- Examine the business model implications
- Discuss what this tells us about the market
- Acknowledge what each company does well

Make it fair but critical. Don't assume one is "right"—analyze the tradeoffs.

Target length: 500-700 words
Tone: Analytical skeptic who respects both but sees problems in each

Give me the outline first.
```

## Scenario 7: Industry Consolidation Pattern

**Situation:** Noticing a trend in how vendors are positioning themselves

**Prompt to Claude:**
```
Use the critical article writer skill to examine the trend where [pattern].

Key observations:
- [Company A] is doing [strategy]
- [Company B] just announced [related move]
- [Company C] appears to be following [similar path]

Article should:
- Explain what's happening
- Analyze why (what incentive drives this)
- Show the implications if this continues
- Discuss impact on [users/market/industry]
- Acknowledge if this pattern is actually healthy

Target audience: Industry insiders and strategists
Target length: 600 words
Tone: Concerned but curious—what are we watching unfold?

Create outline for approval first.
```

## Scenario 8: Myth-Busting Article

**Situation:** Common belief about AI/tech that doesn't match reality

**Prompt to Claude:**
```
Use the critical article writer skill to write a myth-busting article.

Myth: [What people believe]
Reality: [What the data actually shows]
Why people believe the myth: [Explanation of misconception source]

Article should:
- Hook with the myth people believe
- Introduce why this matters
- Present the actual evidence layer by layer
- Explain where the myth came from
- Discuss implications of people believing false version
- Give readers new mental model

Make it educational without being condescending.
Target audience: People knowledgeable but potentially misled
Target length: 500-700 words

Start with outline for review.
```

---

## Pro Tips for Prompting

1. **Always request outline first** - You can approve structure before full article is written
2. **Be specific about evidence** - Share your sources or data upfront
3. **Clarify audience knowledge level** - This affects how much explaining is needed
4. **Mention tone concerns** - "More skeptical" or "More diplomatic" helps Claude calibrate
5. **Include length preferences** - Word count or post count guides output
6. **Share what resonates** - Tell Claude which parts felt most authentic
7. **Iterate on voice** - If something doesn't sound right, ask for adjustments to tone

## Common Adjustments

**If too academic:** Ask Claude to "make it more conversational and direct"  
**If too casual:** Ask for "more evidence and technical precision"  
**If uncertain tone:** Ask to "lean more into skepticism"  
**If too harsh:** Ask to "add more acknowledgment of legitimate counterarguments"  
**If not engaging enough:** Ask to "include more rhetorical questions"  

---

**Copy-paste these scenarios and customize for your specific article ideas.**
