# Quick Reference Guide

## 🔥 Your Critical Voice in One Page

### The Sound

**"Well, who could've seen this coming… [company] just announced they need $500M more in funding. Here's why their financial model is starting to look more and more like a Ponzi scheme..."**

---

## 🎯 Voice in 3 Dimensions

### Dimension 1: CRITICAL
- Skepticism about corporate claims
- Questions underlying assumptions  
- Points out unsustainable models
- Challenges conventional wisdom
- Example: "How does this math work?"

### Dimension 2: CONVERSATIONAL
- Speaks directly to readers
- Informal but informed
- Rhetorical questions engage
- Personal observations shared
- Example: "You might've noticed this too..."

### Dimension 3: STRATEGIC
- Humor serves the argument
- Examples illuminate thinking
- Evidence supports claims
- Structured yet flowing
- Example: "Great work [Company] - very bold assumption"

---

## 📝 Content Architecture

```
ARTICLE SHAPE
═════════════

HOOK (attention + stakes)
    ↓
CONTEXT (what people believe)
    ↓
PROBLEM (why that's wrong)
    ↓
EVIDENCE (data telling real story)
    ↓
IMPLICATIONS (what this means)
    ↓
NUANCE (where you might be wrong)
    ↓
CLOSE (sharp observation)
```

---

## 💬 Opening Patterns You Use

| Pattern | Example |
|---------|---------|
| **Observation** | "Well, who could've seen this coming..." |
| **Question** | "What am I missing here?" |
| **Comparison** | "Compare this to what they said last quarter..." |
| **Data** | "The numbers on this are genuinely wild..." |
| **Experience** | "After 3.5 years building these tools..." |

---

## 🎨 Writing Techniques Checklist

- [ ] Short punchy sentences mixed with elaborate ones
- [ ] Em dashes (—) for emphasis and pauses
- [ ] Rhetorical questions engaging the reader
- [ ] Specific examples, not abstractions
- [ ] Evidence integrated throughout
- [ ] Fair acknowledgment of counterarguments
- [ ] Sharp observation to end
- [ ] Links/sources provided for claims
- [ ] Conversational tone without sacrificing substance
- [ ] Humor that serves the argument

---

## 📊 Content Types You Create

### ARTICLE (600-1000 words)
- Deep analysis of trend/claim
- Multiple sections building argument
- Evidence throughout
- Counterarguments addressed
- Specific to detailed

### THREAD (4-7 posts)
- Progressive deepening
- Each post self-contained
- Flows together cohesively
- Hook, build, close
- Shareable pieces

### QUICK TAKE (1-3 sentences)
- Sharp observation
- Specific detail
- Implication clear
- Link included
- Highly sharable

### OUTLINE (structured thinking)
- Topic with angle
- 3-5 main sections
- Evidence placeholders
- Counterargument section
- Blueprint for writing

---

## 🚀 Prompting Formula

```
BASIC:
"Use the critical article writer skill to write about [TOPIC]"

BETTER:
"Use the critical article writer skill to draft an outline about [TOPIC].
Target audience: [WHO]
Key angle: [WHAT YOU'RE EMPHASIZING]
Main evidence: [YOUR KEY FACTS]
Tone: skeptical but fair"

BEST:
"Use the critical article writer skill to:
1. Create an outline arguing [YOUR POSITION]
2. For audience: [WHO THEY ARE]
3. Focusing on [YOUR ANGLE]
4. Using this evidence: [YOUR FACTS]
5. Keep it skeptical but fair
Please outline first for approval."
```

---

## 🎯 Quality Check (30 seconds)

Before finalizing, scan for:

✓ **Opening hook** - Does it grab attention?  
✓ **Evidence** - Is every claim backed up?  
✓ **Voice** - Does it sound like YOU?  
✓ **Flow** - Do ideas connect logically?  
✓ **Close** - Sharp and memorable?  
✓ **Fair** - Counterarguments included?  
✓ **Links** - Sources provided for major claims?  

---

## 💎 Your Distinctive Moves

**What makes YOUR writing unique:**

1. **Skepticism + Intellectual Honesty** - Critical but fair
2. **Specific Examples** - Not vague generalizations  
3. **Sharp Observation** - Memorable closing insights
4. **Conversational Expertise** - Expert who talks like a human
5. **Evidence-Driven** - Claims backed by data
6. **Strategic Humor** - Funny because it's TRUE
7. **Question Framework** - Rhetorical questions engage readers
8. **Pattern Recognition** - You spot recurring dynamics

**Result:** Readers trust you because you're skeptical AND fair, expert AND accessible, entertaining AND substantive.

---

## 🔧 If Claude Isn't Matching...

| Problem | Solution |
|---------|----------|
| Too dry | Add more rhetorical questions, direct address |
| Too casual | Increase evidence, technical precision |
| Too harsh | Add counterargument section, acknowledgments |
| Too uncertain | Clarify your actual position, lead with strongest evidence |
| Not engaging | More specific examples, sharper observations |

---

## 📚 Files at Your Fingertips

| File | Use For |
|------|---------|
| **SKILL.md** | Complete reference (15,000+ words) |
| **README.md** | How to use the skill |
| **GETTING_STARTED.md** | Quick start guide |
| **voice-tone-checklists.md** | Quality control |
| **outline-templates.md** | Structure your content |
| **opening-lines-reference.md** | Inspiration for hooks |
| **common-scenarios.md** | Example prompts |

---

## 🎓 Master Prompts

**BEST FOR OUTLINES:**
"Use critical article writer skill to outline an article claiming [position]. Audience: [who]. Focus on [angle]. Evidence: [your facts]. Structure first, then I'll approve."

**BEST FOR FULL ARTICLES:**
"Write [length] article using critical article writer skill about [topic]. Skeptical take on [claim]. Use [evidence]. Maintain fair but critical tone throughout."

**BEST FOR THREADS:**
"Create [X]-post thread using critical article writer skill. Topic: [what]. Progression: hook → deep dive → close. Include hashtags, maintain voice."

**BEST FOR QUICK TAKES:**
"Generate [X] quick takes using critical article writer skill about [topic]. Each: observation + detail + implication. Include links."

---

## ✨ The Core Promise

This skill ensures that every piece you create:

🎯 **Sounds like you** - Not AI, not generic, distinctively YOUR voice  
🔍 **Is intellectually honest** - Skeptical but fair, critical but credible  
📊 **Is well-supported** - Evidence integrated throughout  
💬 **Engages readers** - Questions, examples, direct address  
🎨 **Maintains consistency** - Same voice across all pieces  

---

**Version:** 1.0 Quick Reference  
**Purpose:** Fast lookup guide for voice, structure, and prompting  
**Created:** November 2025

Use this page when you need a quick reminder of your voice or when coaching Claude on tone adjustments.
