# CAC Crusher — Creator Screening Framework

Source: Sankalp Tipatle (sankalp@caccrusher.in), Feb 27 2026

## 1. Creator Categories

**A. Talking Head Creators**: Seated, direct-to-camera, structured explanation / video essay
**B. Skit / Drama / Couple Creators**: Performance-based, dialogue-driven, individual or couple-led

## 2. Universal Production Standards (Non-Negotiable)

### 2.1 Look & Feel (Lighting, Environment, Clothing, Framing)

Overall visual must feel **modern, clean, intentional, premium** — comparable to tier-1 digital creators.

**PASS criteria:**
- Indoor controlled lighting
- Evenly lit face (no harsh shadows or blown highlights)
- Balanced, soft lighting
- Clean, well-maintained interiors
- No clutter or distracting elements
- Neat, intentional dress
- Well-groomed (hair, beard, makeup)
- Stable, centered, well-balanced framing
- Proper headroom and side spacing
- High-resolution, sharp footage
- Proper color balance

**FAIL criteria (any one = reject):**
- Dim, uneven, or poorly exposed lighting
- Rural/farm-like or visibly unpolished environments
- Muddy, damaged, stained, or distracting wall backgrounds
- Casually unkempt or poorly styled
- Wrinkled or careless clothing
- Extreme, distracting, or unnaturally colored hairstyles
- Blurry, grainy, or low-resolution cameras
- Awkward cropping or careless composition

### 2.2 Audio Quality

**PASS criteria:**
- Clear, crisp, distortion-free voice
- Balanced and consistent volume
- Minimal echo or room noise
- Clean microphone output

**FAIL criteria:**
- Muffled or boxy audio
- Echo-heavy or noisy environments
- Over-processed or distorted sound
- Inconsistent volume levels

## 3. Format-Specific Filters

### 3.1 Talking Head (Higher Maturity Standard)

**PASS criteria:**
- Appears mature and composed
- Speaks fluently with strong vocabulary
- Explains concepts clearly and confidently
- Steady delivery (minimal fumbling/stuttering)
- Natural, controlled hand gestures
- Sits and speaks directly to camera
- Centered, intentional framing
- Demonstrates confidence and structured thought

**FAIL criteria:**
- Visibly childish tone or expressions
- Exaggerated, meme-style, or theatrically loud delivery
- Frequent fumbling or rhythm breaking
- Lack of clarity in articulation
- Poor camera sharpness or color grading
- Standing casual monologue-style videos
- Background music with text overlays only (no speech)
- Silent reaction-style videos
- Trending audio without meaningful verbal explanation
- Lip-sync to audio

### 3.2 Skit / Drama / Couple

**PASS criteria:**
- Clear, intentional dialogues
- Music as background support (not primary content)
- Confident line delivery
- Strong screen presence
- Well-groomed and composed
- Structured, scenario-driven content

**FAIL criteria:**
- Primarily dance or lip-sync without dialogue
- Entirely dependent on trending music formats
- Exaggerated emotional drama reels
- Dramatic background music with over-the-top acting
- Theatrically immature
- Visibly unpolished or rural-style settings
- Low-resolution or unstable footage
- Trend-dependent, impulsive reels without structured narrative
- Lip-sync/reaction reels using devotional, motivational, or politically-charged audio as primary content

## 4. Positioning Standard (Core Intent)

Across all formats, creators must reflect:
- Maturity in tone
- Premium but relatable presence
- Structured communication
- Controlled energy (not chaotic or loud)
- Intentional production quality
- Dialogue-driven content (not passive trend mimicry)

**Reject signals:**
- Childlike energy
- Over-dramatic emotional storytelling
- Trend-chasing formats
- Loud theatrical exaggeration
- Rural or visibly low-production aesthetics

## 5. Final Screening Rule

A creator moves forward ONLY if:
1. Universal production standards are met
2. Format-specific standards are satisfied
3. Maturity and positioning standards align
4. No strong red flags exist

**If a single major red flag appears in lighting, environment, grooming, maturity, delivery, or audio quality — REJECT.**

## Scoring Template

For each creator, evaluate and score:

```
Profile: @username
Category: A (Talking Head) / B (Skit/Couple)
Followers: N | Verified: Y/N | Avg Views: N | Engagement: N%

Section 2.1 Look & Feel:    PASS / FAIL / FLAG — [notes]
Section 2.2 Audio Quality:   PASS / FAIL / FLAG — [notes]
Section 3.x Format-Specific: PASS / FAIL / FLAG — [notes]
Section 4 Positioning:       PASS / FAIL / FLAG — [notes]
Red Flags:                   None / [list]

VERDICT: APPROVED / REJECTED / CONDITIONAL
```
