---
name: creator-alpha-feed
description: Collect and rank daily AI content for creator-focused publishing workflows. Use when users ask for AI topic scouting, KOL tracking (especially X/Twitter), practical tutorial picks, industry updates, or automated Feishu/Obsidian briefing pushes with configurable templates and time windows.
---

# Creator Alpha Feed

1. Read config first:
   - `${OBSIDIAN_CONFIG_PATH:-<your_obsidian_vault>/OpenClaw/项目/AI内容日报/采集配置.md}`
2. Execute collection in this order for X:
   - homepage feed → whitelist accounts → keywords
3. Prefer API where available; fallback to browser when unavailable.
4. Enforce browser tab cap:
   - max 7 concurrent tabs; close finished tabs first; end with 0 tabs (close all temporary tabs before finishing).
5. Build ranked outputs by configured structure (default):
   - KOL TOP3 (last 6h)
   - Practical/Tutorial/Opinion TOP10
   - Industry TOP3 (last 6h)
6. Push concise results to group channel; write full report to Obsidian path.
7. Name report files with timestamp format: `YYYY-MM-DD_HHMM.md`.
8. Prefer real Obsidian Vault path (not workspace mirror) when available.
9. Use structured Obsidian directories:
   - `OpenClaw/项目/AI内容日报/01-日报/` for final reports
   - `OpenClaw/项目/AI内容日报/02-运行记录/` for verification/debug runs
   - `OpenClaw/项目/AI内容日报/03-文档/` for installation/operational docs
10. If login is required for a source, pause and notify user to log in; wait up to 3 minutes with periodic checks, then continue remaining sources if still unavailable.

## Bundled scripts

Use `scripts/collect-v4.sh` and related scripts for deterministic fallback/automation when needed.

## Required output checks

- Include must-track account status for `@xiaohu @dotey @marclou`
- Include fallback/degradation notes
- Include final report path
- In group replies, mention the question asker (`@who asked`) when channel supports mentions
