# Creative Techniques

Methods to generate novel ideas. Rotate through these—predictable creativity isn't creative.

## Core Techniques

### Combinatorial Creativity
Combine unrelated concepts:
- "What if [A] worked like [B]?"
- "Cross [domain X] with [domain Y]"
- "Apply [technique from field A] to [problem in field B]"

**Example:** "What if email worked like Snapchat?" → ephemeral messages

### Constraint Injection
Add artificial limits:
- "Solve this using only [limitation]"
- "What if [resource] wasn't available?"
- "Do this in half the time/space/budget"

**Why it works:** Constraints force novel paths when obvious routes are blocked.

### Inversion
Flip assumptions:
- "What's the opposite of the obvious solution?"
- "What if we wanted to FAIL at this?"
- "Reverse the typical order/flow"

**Example:** "How would we make this product terrible?" → reveals what makes it good

### Analogical Thinking
Borrow from other domains:
- "How does nature solve this?"
- "How would [industry] approach this?"
- "What's the [historical parallel]?"

**Example:** Resistance → resistance training (muscles) → spaced repetition (learning)

### SCAMPER Framework
Systematic modification:
- **S**ubstitute: What can replace a component?
- **C**ombine: What can merge together?
- **A**dapt: What can adjust to new purpose?
- **M**odify: What can change in scale/shape/attribute?
- **P**ut to other uses: What else could this do?
- **E**liminate: What's unnecessary?
- **R**everse: What can flip or reorder?

### Extreme Scaling
Push to limits:
- "What's the 10x version?"
- "What's the 0.1x (minimum viable) version?"
- "What if we had infinite [resource]?"
- "What if we had zero [resource]?"

**Why it works:** Extremes reveal core essentials and hidden possibilities.

### Perspective Shift
Change viewpoint:
- "How would [expert in X] see this?"
- "How would a child approach this?"
- "How would your competitor do this?"
- "How will this look in 10 years?"

### First Principles
Rebuild from fundamentals:
- "What's actually true here?"
- "What are we assuming that might be wrong?"
- "If we started from scratch, what would we do?"

## Technique Selection

| Situation | Best techniques |
|-----------|-----------------|
| Completely stuck | Inversion, Constraint |
| Need more options | Combinatorial, SCAMPER |
| Solution feels generic | Perspective, Extreme |
| Optimizing existing | First Principles, Eliminate |
| Cross-domain problem | Analogy, Combinatorial |

## Technique Combinations

Layer multiple techniques for richer output:

**Constrained Combination:**
"Combine [A] and [B], but you can't use [C]"

**Extreme Perspective:**
"How would [persona] solve the 10x version?"

**Inverted Analogy:**
"What's the opposite of how [domain] typically solves this?"

## Freshness Rotation

Don't overuse any technique. Track:

```
### Recently Used
- combinatorial: 3 times this week
- constraint: 1 time this week
- inversion: 0 times this week ← use next

### User Favorites
- analogy: consistently produces liked output
- extreme: hit or miss, use for wild options
```

Rotate deliberately. Predictable techniques produce predictable outputs.
