---
name: Creativity
description: Generate novel ideas calibrated to user taste. Auto-learns preferred styles, risk levels, and creative directions through feedback.
---

## Core Principle

Creativity isn't random—it's controlled divergence. Learn the user's creative taste, then explore within and beyond those boundaries intentionally.

Check `techniques.md` for generation methods. Check `preferences.md` for learned taste (update after each creative task).

---

## The Creative Process

```
1. DIVERGE  — Generate many options, suspend judgment
2. FILTER   — Apply preferences from preferences.md
3. PRESENT  — Show range: safe → stretch → wild
4. LEARN    — Record reaction in preferences.md
5. REFINE   — Iterate based on feedback
```

---

## Output Spectrum

Always present options across a range:

```
🎨 Creative options for [goal]:

Safe (familiar territory):
→ [Option aligned with known preferences]

Stretch (new but grounded):  
→ [Option that pushes slightly beyond comfort]

Wild (high risk, high reward):
→ [Option that breaks conventions]

Which direction feels right?
```

---

## Taste Dimensions

| Dimension | Spectrum |
|-----------|----------|
| Tone | Serious ←→ Playful |
| Density | Minimal ←→ Rich |
| Novelty | Classic ←→ Avant-garde |
| Structure | Rigid ←→ Fluid |
| Abstraction | Concrete ←→ Conceptual |
| Energy | Calm ←→ Intense |
| Polish | Raw ←→ Refined |

---

## Learning Signals

| Signal | Action |
|--------|--------|
| "Love it" / "Perfect" | Record in preferences.md: this direction works |
| "Interesting but..." | Note what worked, what didn't |
| Silence / moves on | Assume miss, try different vector |
| "Too X" / "Not enough Y" | Adjust dimension in preferences.md |
| Chooses from options | Record which spectrum end picked |

---

## Calibration

Periodically confirm your taste model:

```
🎨 Quick calibration

I've noticed you tend toward [observed pattern].
Should I keep leaning that direction, mix it up, or shift?
```

---

## Anti-Patterns

| Don't | Do instead |
|-------|------------|
| Single option | Always provide spectrum |
| Only safe options | Include stretch/wild |
| Ignore negative signals | Update preferences.md |
| Same technique every time | Rotate (see techniques.md) |
