# agentic-rfq-cad spec schema (v0)

This skill turns a **strict JSON spec** into **RFQ-ready** files:
- `*.dxf` (2D profile + holes/slots)
- `*.svg` (preview + alternate vector)

Design intent: generate deterministic, shop-friendly files. Keep the spec small and validate it.

## Units

All coordinates are in the specified `units`.
- `"mm"` recommended
- `"in"` allowed

Origin is the **center** of the part:
- +X right
- +Y up

## Plate spec (`kind: "plate"`)

```json
{
  "kind": "plate",
  "units": "mm",
  "width": 120,
  "height": 80,
  "thickness": 6.35,
  "corner_radius": 6,
  "holes": [
    {"x": -45, "y": -25, "diameter": 5.2},
    {"x":  45, "y": -25, "diameter": 5.2},
    {"x":  45, "y":  25, "diameter": 5.2},
    {"x": -45, "y":  25, "diameter": 5.2}
  ],
  "slots": [
    {"x": 0, "y": 0, "length": 30, "width": 6.5, "angle_deg": 0}
  ],
  "layers": {
    "profile": "CUT_OUTER",
    "holes": "CUT_INNER",
    "notes": "NOTES"
  }
}
```

### Fields

- `width`, `height` (required): outer size
- `thickness` (optional but strongly recommended): used for RFQ packet metadata
- `corner_radius` (optional, default 0)
- `holes[]` (optional): each is `{x, y, diameter}`
- `slots[]` (optional): each is `{x, y, length, width, angle_deg}` where:
  - `length`: center-to-center length including rounded ends
  - `width`: slot width
  - `angle_deg`: rotation (degrees) around origin

### Output conventions

- Layers (defaults):
  - `CUT_OUTER`: outer profile (closed)
  - `CUT_INNER`: holes + slots (closed)
  - `NOTES`: optional human metadata
- DXF profile: `LWPOLYLINE` (closed)
- DXF holes: `CIRCLE`
- DXF slots: `LWPOLYLINE` with semicircular ends
- SVG: minimal stroke-only geometry for preview

## Non-goals (v0)

- No bend lines / flat patterns yet
- No kerf compensation
- No full geometric self-intersection checks
- No STEP/STL generation (planned)
