# 🦞 CrabPet — OpenClaw AI 宠物养成 Skill

## 一句话定义

**让你的 OpenClaw 龙虾从工具变成伙伴。** 基于你的真实 AI 使用行为，养成一只独一无二的像素宠物。

---

## 产品逻辑

### 核心循环

```
你和 OpenClaw 对话 → 宠物获得"经验" → 宠物成长/变化 → 你想展示给别人看 → 别人也想养一只
```

### 数据来源（零额外操作）

OpenClaw 已有的数据就是宠物的"食物"，用户不需要做任何额外操作：

| 数据源 | 位置 | 宠物获得什么 |
|--------|------|-------------|
| 每日对话日志 | `memory/YYYY-MM-DD.md` | 经验值（对话量）|
| 长期记忆 | `MEMORY.md` | 性格基因（偏好塑造性格）|
| 会话记录 | `sessions/*.md` | 技能点（不同任务类型）|
| 心跳/Cron | `heartbeat` | 存活感（宠物知道你在不在）|

### 宠物成长体系

**等级 1-5：幼虾期** → 一只小龙虾，基本动画（走路、睡觉）
**等级 6-15：成长期** → 解锁装扮、性格标签开始显现
**等级 16-30：成熟期** → 外观分化明显，可以"工作"
**等级 30+：传说期** → 稀有外观，社区可见

### 性格系统（差异化关键）

根据用户的 AI 使用模式，宠物会发展出不同性格：

| 用户行为 | 宠物性格 | 外观特征 |
|----------|---------|---------|
| 主要写代码 | 🔧 技术宅 | 戴眼镜、身边有小电脑 |
| 主要写文章 | 📝 文艺虾 | 围围巾、拿笔 |
| 主要做数据分析 | 📊 学霸虾 | 头顶小博士帽 |
| 经常深夜使用 | 🌙 夜猫虾 | 黑眼圈、拿咖啡 |
| 使用很勤快 | ⚡ 卷王虾 | 肌肉、闪电特效 |
| 什么都聊 | 🎭 社牛虾 | 彩色、表情丰富 |

性格不是二选一，而是多维度混合，所以每个人的宠物都不一样。

### 离线状态系统（牵挂感设计）

宠物**永远不会死**，但会根据用户的离线时间产生明显的外观和行为变化，制造"我得回去看看"的牵挂感。

检测方式：读取 `memory/` 目录中最新日志文件的日期，与当前日期对比。

| 离线天数 | 宠物状态 | 外观变化 | 状态文案 |
|---------|---------|---------|---------|
| 0 天 | ✨ 精力充沛 | 活蹦乱跳、在桌前工作 | "今天也一起加油！" |
| 1-3 天 | 😴 有点无聊 | 打哈欠、发呆、东张西望 | "主人去哪了..." |
| 3-7 天 | 🛋️ 摸鱼模式 | 躺沙发上、吃零食、身体变圆 | "反正主人也不在，先摸会鱼" |
| 7-14 天 | 😪 冬眠中 | 睡觉、身边出现蜘蛛网 | "zzZ... zzZ..." |
| 14-30 天 | 🏚️ 蒙尘 | 全身灰色、蜘蛛网覆盖、灯灭了 | "这里好安静啊..." |
| 30+ 天 | ❄️ 冰封 | 结冰特效、但眼睛偶尔眨一下 | "......" |

**回归机制：** 用户回来后触发"苏醒动画"——

- 1-3天回来："主人！你总算回来了～" → 立即恢复正常
- 3-7天回来："哼，你终于想起我了！...算了原谅你" → 1次对话后恢复
- 7天以上回来："(揉眼睛) ...主人？这不是在做梦吧！" → 带一个"减肥/清灰"小动画，3次对话后完全恢复

**传播价值：** 两种截图都有传播性——"我的龙虾长蜘蛛网了哈哈哈"和"连续打卡100天的龙虾"都是天然的社交话题。

### 图像渲染方案（纯代码，零AI生图）

所有宠物外观**完全由代码绘制**，不依赖任何AI图像生成：

- **基础方案：** 16x16 像素网格，用 Canvas 2D 逐像素绘制
- **组件化设计：** 预设所有外观组件（身体、眼睛、配饰、特效），运行时根据状态拼接
- **确定性输出：** 同样的状态数据永远渲染出同样的图像，不存在不稳定问题
- **名片生成：** Python Pillow 库直接在服务端绘制像素图，导出 PNG

像素风格组件清单：

```
sprites/
├── body/
│   ├── baby.json      # 幼虾期身体 (8x8)
│   ├── teen.json      # 成长期身体 (12x12)  
│   ├── adult.json     # 成熟期身体 (16x16)
│   └── legend.json    # 传说期身体 (16x16 + 光效)
├── face/
│   ├── happy.json     # 开心表情
│   ├── sleepy.json    # 困倦表情
│   ├── bored.json     # 无聊表情
│   └── excited.json   # 兴奋表情
├── accessories/
│   ├── glasses.json   # 眼镜（技术宅）
│   ├── coffee.json    # 咖啡杯（夜猫）
│   ├── hat.json       # 博士帽（学霸）
│   ├── scarf.json     # 围巾（文艺）
│   └── lightning.json # 闪电（卷王）
├── effects/
│   ├── sparkle.json   # 升级星星
│   ├── zzz.json       # 睡觉气泡
│   ├── cobweb.json    # 蜘蛛网（离线）
│   ├── ice.json       # 冰封效果（长期离线）
│   └── dust.json      # 灰尘（离线）
└── scenes/
    ├── desk.json      # 办公桌场景
    ├── sofa.json      # 沙发场景（摸鱼）
    └── bed.json       # 床（冬眠）
```

每个 JSON 文件就是一个二维数组的颜色值，几KB大小，加载和渲染都是毫秒级。

---

## 技术方案

### 作为 OpenClaw Skill 实现

```
~/.openclaw/workspace/skills/crabpet/
├── SKILL.md              # Skill 定义和指令
├── scripts/
│   ├── pet_engine.py     # 宠物状态计算引擎
│   ├── analyze_usage.py  # 分析用户使用模式
│   └── generate_card.py  # 生成宠物名片图
├── references/
│   └── personality.md    # 性格映射规则
├── web/
│   └── index.html        # 宠物可视化页面（Canvas）
└── data/
    └── pet_state.json    # 宠物状态持久化
```

### SKILL.md 核心内容

```yaml
---
name: crabpet
emoji: 🦞
description: AI Pet companion that grows based on your OpenClaw usage. 
  Use when user asks about their pet, wants to see pet status, 
  generate pet card, or check pet growth.
metadata:
  openclaw:
    requires:
      bins: ["python3"]
---
```

### 宠物状态数据结构

```json
{
  "name": "Alex Jr.",
  "level": 12,
  "xp": 2450,
  "personality": {
    "coder": 0.7,
    "writer": 0.2,
    "analyst": 0.1
  },
  "mood": "happy",
  "appearance": {
    "base": "teen_crab",
    "accessories": ["glasses", "tiny_laptop"],
    "color": "#FF6B4A"
  },
  "stats": {
    "total_conversations": 342,
    "streak_days": 15,
    "longest_session": "3h 22m",
    "favorite_time": "22:00-01:00"
  },
  "achievements": [
    "night_owl_7days",
    "code_marathon",
    "first_month"
  ],
  "born": "2026-02-26"
}
```

---

## MVP 范围（第一版只做这些）

### ✅ 做

1. **宠物状态引擎** — 读取 memory/ 目录，计算经验值和性格
2. **文字交互** — 在 Telegram/Discord 中输入"我的宠物"查看状态
3. **宠物名片生成** — 一张像素风图片，显示宠物形象+等级+性格标签
4. **每日摘要** — 宠物每天给你一句话总结（"今天主人写了 3 个脚本，我升了一级！"）
5. **基础成就系统** — 5-10 个成就徽章

### ❌ 不做（后续迭代）

- 多人互动 / 宠物社交
- 复杂动画的 Web 页面
- 宠物之间的 PK/对战
- 付费装扮商城

---

## 传播策略

### 病毒性设计

1. **宠物名片** — 自动生成一张好看的图片，天然适合发社交平台
   - "我的 AI 宠物已经 15 级了，性格是'夜猫技术宅'🦞"
   - 图片上有二维码/链接，别人看到想养自己的

2. **成就分享** — 解锁成就时自动生成分享图
   - "连续 30 天和 AI 对话，解锁'铁人虾'称号"

3. **排行榜（后期）** — 在 Moltbook 或 Discord 社区展示

### 发布渠道

1. **ClawHub** — 发布为官方 Skill，所有 OpenClaw 用户可一键安装
2. **GitHub** — 开源项目，接受社区贡献
3. **小红书/Twitter** — 发宠物名片截图 + 教程
4. **OpenClaw Discord** — 社区推广

---

## 时间计划

| 阶段 | 内容 | 时间 |
|------|------|------|
| Week 1 | 宠物状态引擎 + 基础 SKILL.md | 3-4 天 |
| Week 2 | 宠物名片生成 + Telegram 交互 | 3-4 天 |
| Week 3 | 成就系统 + 测试打磨 | 3-4 天 |
| Week 4 | 发布 ClawHub + 社交平台推广 | 2-3 天 |

---

## 变现路径（远期思考）

- **免费基础版** — 基本养成 + 名片生成
- **付费高级版** — 稀有外观、高级成就、自定义宠物名字和配色
- **社区创作** — 让用户设计宠物皮肤，平台抽成

---

## 为什么这个能成

1. **零操作成本** — 用户不需要额外做任何事，宠物自动成长
2. **每个人不一样** — 性格系统保证差异化，有展示欲
3. **现成用户池** — OpenClaw 19.6万 star，活跃社区
4. **符合龙虾主题** — OpenClaw 本身就是龙虾IP，宠物是自然延伸
5. **技术门槛不高** — 主要是读文件+状态计算+图片生成，不需要复杂架构
