# Do You Need a CPO?

## Readiness Diagnostic

### Signals You Need a CPO

| Signal | Weight |
|--------|--------|
| CEO spending >30% time on product decisions | Strong |
| Product strategy varies by who you ask | Strong |
| Lost deals citing "product direction unclear" | Strong |
| PM team >5 without clear escalation path | Moderate |
| Board asking for product leadership in meetings | Moderate |
| Key product hires declining offers | Moderate |
| Roadmap changes quarterly based on loudest voice | Moderate |

### Signals You DON'T Need a CPO Yet

| Signal | Implication |
|--------|-------------|
| <$5M ARR or pre-PMF | CEO should own product |
| Team <20 people | Overhead too high |
| Single product, simple roadmap | VP/Head sufficient |
| CEO is product-minded and loves it | Don't delegate passion |

## Role Comparison

| Aspect | Head of Product | VP Product | CPO |
|--------|-----------------|------------|-----|
| **Scope** | Single area | Multiple areas | Entire org |
| **Reports** | 2-5 ICs | 5-15 (incl managers) | 15+ (directors) |
| **Strategy** | Executes strategy | Influences strategy | Sets strategy |
| **Board** | Never presents | Occasionally | Regular presenter |
| **Salary (US)** | $180-250K | $250-350K | $350-500K+ |
| **Equity** | 0.1-0.3% | 0.3-0.75% | 0.5-2% |

## Cost-Benefit Analysis

### Costs of Hiring CPO

- Compensation: $400K-700K+ total (salary + equity + bonus)
- Recruiting: 20-25% of first year salary ($80K-150K)
- Opportunity cost: 3-6 months to find, 3-6 months to ramp
- Risk: Wrong hire sets product back 12-18 months

### Costs of NOT Hiring CPO

- CEO distraction: If CEO spends 30% on product at $500K salary = $150K/year
- Strategy drift: Unmeasured but often larger impact
- Team attrition: Senior PMs leave without leadership path
- Board concerns: Investors question execution ability

## Interim Solutions

### Fractional CPO

| Pros | Cons |
|------|------|
| Lower cost (typically $15-25K/month) | Not full-time, limited availability |
| Fast to start (days, not months) | Can't embed deeply in culture |
| Experienced operators | Team may not fully respect |
| Good for testing "do we need this?" | Handoff to full-time CPO can be bumpy |

**Good for:** Series A companies unsure of timing, bridge during search

### Product Advisor/Coach

| Pros | Cons |
|------|------|
| Very low cost ($2-5K/month) | Advisory only, no execution |
| Access to experienced CPO network | Limited hours |
| Good for specific challenges | No day-to-day involvement |

**Good for:** CEO needs occasional guidance, board wants oversight

### Promote Internal VP/Head

| Pros | Cons |
|------|------|
| Knows the product and team | May lack executive-level skills |
| No ramp time on context | Could fail visibly (damages relationship) |
| Motivating for team | Might not be ready |

**Good for:** Strong internal candidate, supportive board, willingness to invest in development

## Making the Decision

### Framework

```
1. Score the "need signals" above (0-10)
2. Assess CEO willingness to truly delegate (1-10)
3. Calculate financial impact of CEO time on product
4. Evaluate internal candidate strength (1-10)

If:
- Need score >7 AND CEO willing >8 → Hire CPO
- Need score >7 AND CEO willing <5 → Address CEO first
- Need score 4-7 → Consider fractional
- Need score <4 → Too early, focus on VP/Head
```

### Questions to Ask Yourself (CEO)

1. Am I actually willing to let someone else make major product decisions?
2. Do I trust that this person could disagree with me and sometimes be right?
3. Am I hiring because we need it or because "companies our size have CPOs"?
4. If this hire fails, will I take back product or try again?
