# Hiring Your First CPO

## Stage-Appropriate JD Generation

Before writing a job description, gather:
- Company stage (seed, Series A/B/C, public)
- Product complexity (single vs multi-product)
- Team size (how many PMs will report)
- Technical depth required
- B2B vs B2C experience needed
- 0→1 vs scaling focus

## Candidate Scorecard Template

| Competency | Weight | Questions to Assess |
|------------|--------|---------------------|
| Product Strategy | 25% | How do you define product vision vs roadmap? Walk me through a strategy you set. |
| Team Leadership | 20% | How do you develop PM managers? Describe a hire that didn't work. |
| Stakeholder Management | 15% | How do you handle CEO/board disagreement on direction? |
| Technical Judgment | 15% | How do you make build vs buy decisions? When do you push back on engineering? |
| Go-to-Market | 15% | How do you partner with sales/marketing on launches? |
| Customer Obsession | 10% | How do you stay close to customers at scale? |

## Compensation Benchmarking

Research for similar stage companies:
- Base salary ranges
- Equity percentage (typically 0.5-2% at Series A, decreasing with stage)
- Bonus structure
- Signing bonus norms
- Vesting schedules (4-year standard, some offer acceleration)

## Red Flags in Candidates

| Signal | Why It Matters |
|--------|----------------|
| Only "strategic" roles, no shipped products | May not execute |
| Short tenures (<18 months) repeatedly | Flight risk or performance issues |
| Vague metrics ("improved user experience") | Can't quantify impact |
| Title inflation (CPO at 10-person startup) | May not scale |
| No management experience | CPO requires managing managers |
| Can't articulate failures | Lacks self-awareness |

## Reference Check Framework

Questions for former direct reports:
- Would you work for them again? Why or why not?
- How did they handle disagreement with you?
- What's one thing they could improve?

Questions for former peers (engineering, sales leaders):
- How did they handle cross-functional conflict?
- Did they take accountability for product misses?

Questions for former managers (CEO, board):
- What would you change about how they operated?
- How did they perform under pressure?

## Founder-to-CPO Transition Plan

### Days 1-30: Context Transfer
- Full access to customer data, research, metrics
- Meet every team lead 1:1
- Shadow founder in key meetings
- Document current decision-making processes

### Days 31-60: Shared Ownership
- CPO leads roadmap discussions (founder observes)
- CPO presents at one board meeting
- CPO makes 2-3 reversible decisions independently
- Weekly founder-CPO sync on strategy alignment

### Days 61-90: Full Handoff
- CPO owns all product decisions
- Founder provides input only when asked
- Clear escalation paths defined
- CPO has full hiring authority for product org
