# Growing from PM to CPO

## Skills Gap Analysis

### PM Competencies (you likely have)
- Feature specification
- Sprint management
- Direct customer research
- Cross-functional coordination
- Metric tracking

### CPO Competencies (gaps to close)
- Multi-year strategy creation
- Board communication
- Managing managers (not ICs)
- P&L understanding
- Organizational design
- Executive presence
- Investor relations
- Crisis leadership

## Closing the Gap

### Strategic Thinking Practice

Weekly exercises:
1. Take any industry news → write a 2-page "what would I do as CPO of [company]"
2. Read competitor earnings calls → identify product strategy shifts
3. For any major product decision at your company → write the board memo (even if not asked)

### Executive Presence Development

| Weak Signal | Fix |
|-------------|-----|
| Long, meandering emails | Rewrite every email to 3 sentences max before sending |
| Hedging language ("I think maybe...") | Practice decisive language ("We should...") |
| Over-explaining context | Lead with recommendation, context only if asked |
| Deferring in meetings | State your position first, then invite disagreement |

### Managing Managers Playbook

When you get your first PM manager report:
- 1:1s focus on their leadership, not their ICs' tasks
- Ask: "What decisions are you stuck on?" not "What shipped this week?"
- Coach them on coaching, not on product details
- Create space for them to fail safely

## Board-Level Communication

### Translating PM Work to Board Language

| PM Version | Board Version |
|------------|---------------|
| "Improved onboarding flow" | "Reduced time-to-value by 40%, improving 30-day retention" |
| "Built new feature X" | "Expanded TAM by entering [segment]" |
| "Fixed major bugs" | "Reduced churn risk for enterprise accounts" |

### Board Deck Structure (Product Section)

1. **Key Metrics** — 3-4 numbers that matter (not vanity metrics)
2. **Strategic Progress** — What moved toward the north star
3. **Risks & Mitigations** — What could derail us, what we're doing
4. **Resource Needs** — Clear asks with justification

## Building Your CPO Profile

### External Positioning
- Write about strategic product topics (not tactical how-tos)
- Speak at conferences about market trends, not feature launches
- Build relationships with other CPOs (peer network)

### Internal Positioning
- Volunteer for cross-functional strategic initiatives
- Offer to present product strategy to the board (even partially)
- Take on P&L responsibility if available
- Lead company-wide initiatives (not just product team)

## CPO Interview Preparation

### Common CPO Interview Questions

1. "Walk me through how you'd set product strategy for us"
2. "Tell me about a time you killed a product or major feature"
3. "How would you structure our product org given our stage?"
4. "How do you handle CEO/board disagreement on product direction?"
5. "What metrics would you hold yourself accountable to?"

### Case Study Practice

For each company you interview with:
- Research their product deeply (use it, read reviews)
- Prepare a 90-day assessment of what you'd change
- Have a point of view on their competitive positioning
- Know their key metrics (or have informed guesses)
