# CPO Evaluation (Board/Investor Perspective)

## Performance Monitoring

### Health Metrics to Track

| Metric | Source | Frequency | Warning Threshold |
|--------|--------|-----------|-------------------|
| PM team turnover | HRIS/LinkedIn | Quarterly | >20% annual |
| Roadmap delivery rate | Roadmap vs actuals | Quarterly | <70% on-time |
| NPS/CSAT trend | Customer data | Monthly | Declining 2+ quarters |
| Feature adoption | Product analytics | Monthly | <30% of shipped features used |
| Time to ship | Jira/Linear data | Quarterly | Increasing trend |
| Customer churn (product-attributed) | CRM + exit surveys | Monthly | Increasing trend |

### Glassdoor/Blind Sentiment

Monitor for:
- Complaints about product direction
- Mentions of CPO specifically
- "Leadership" concerns in product org
- Comparisons to previous product leadership

## Benchmarking

### Product Velocity Comparison

Compare against similar-stage companies:
- Features shipped per quarter
- Time from idea to production
- Experimentation velocity (A/B tests run)
- Technical debt ratio (new work vs maintenance)

### Market Position Assessment

| Question | Data Sources |
|----------|--------------|
| Are we gaining or losing market share? | G2 grid movement, revenue vs market growth |
| How does our product compare to competitors? | G2 reviews, win/loss analysis |
| Are we leading or following on features? | Competitor release tracking |
| What's our innovation rate? | % revenue from products <2 years old |

## Warning Signs

### Early Warning (Address Proactively)

- Roadmap slips 2+ quarters in a row
- Key product leaders departing
- CEO starting to attend product meetings again
- Board not getting clear product updates
- Strategy presentations lack conviction

### Serious Concerns (Intervention Required)

- Multiple executives expressing CPO concerns
- Customer escalations citing product direction
- CPO disengaged from team (not in meetings, delegating everything)
- Product team morale visibly low
- Metrics declining without clear plan

### Critical (Consider Change)

- CPO lost trust of engineering leadership
- Major product bet failed without accountability
- Team exodus (3+ senior departures in 6 months)
- CPO unable to articulate strategy coherently
- CEO has resumed de facto product leadership

## Supporting Struggling CPOs

### Diagnosis Framework

| Symptom | Possible Causes | Interventions |
|---------|-----------------|---------------|
| Strategy unclear | New to role, unclear mandate | Executive coach, CEO alignment |
| Team issues | Poor management skills | Leadership training, chief of staff |
| Execution problems | Over-indexing on strategy | COO/VP Ops support, clear OKRs |
| Stakeholder conflicts | Political naivety | Mentor from board, CEO coaching |
| Burnout signs | Unsustainable workload | Scope reduction, support hires |

### Intervention Options

1. **Executive coaching** — Best for skills gaps, first-time CPOs
2. **Peer mentorship** — Connect with experienced CPO from network
3. **Scope adjustment** — Reduce responsibilities temporarily
4. **Support hires** — Chief of staff, VP Operations
5. **Clear OKRs** — Make expectations explicit and measurable
6. **Timeline** — Set 90-day improvement plan with checkpoints

## Succession Planning

### Maintaining a Shortlist

Continuously track:
- CPOs at companies one stage ahead (they've seen the next phase)
- VP Products at larger companies (ready to step up)
- Internal high-potentials (1-2 year development path)
- Fractional CPOs who've impressed

### Emergency Succession Plan

Document and update quarterly:
1. **Interim leader** — Who internally could cover for 3-6 months?
2. **External emergency options** — Fractional CPOs who know the space
3. **Critical knowledge** — What does only the CPO know?
4. **Handoff docs** — Strategy docs, roadmap rationale, team dynamics

## Due Diligence (New Investment)

### Product Leadership Assessment

| Area | Questions | Red Flags |
|------|-----------|-----------|
| Track record | What products have they shipped? With what outcomes? | Vague answers, no metrics |
| Team | Who have they hired? Who's left? | High turnover, weak bench |
| Strategy | Can they articulate why the roadmap is what it is? | Feature list, no narrative |
| Customer connection | How often do they talk to customers? | "That's the PM team's job" |
| Self-awareness | What have they gotten wrong? | Can't name failures |

### Product Org Maturity Signals

| Stage | What Good Looks Like |
|-------|---------------------|
| Seed | Founder-led product, CPO is overkill |
| Series A | Strong VP/Head, maybe first-time CPO |
| Series B | Experienced CPO, PM managers in place |
| Series C+ | CPO with board presence, Director layer, PM ops |
