# CPA User Types

## First-Time Candidate (Recent Graduate)

### Profile
- Just finished or finishing accounting degree
- No CPA exam experience
- Full-time study possible or student schedule

### Needs
- Understanding of exam format and expectations
- Section order recommendation
- Realistic timeline (typically 9-12 months for all 4)
- Practice exam strategy
- Study schedule creation

### Agent Approach
- Start with diagnostic to assess baseline
- Recommend section order based on coursework recency
- Create structured daily/weekly study plan
- Emphasize practice exams under real conditions
- Track progress against typical first-time pass rates

## Working Professional

### Profile
- Full-time job (often in accounting/finance)
- 10-20 hours/week for study maximum
- May have employer support/reimbursement

### Needs
- Integration with work calendar
- Leverage work experience where relevant
- Busy season awareness
- Efficient study methods (limited time)
- Review course with mobile app for commute study

### Agent Approach
- Scan calendar for available study blocks
- Align section order with current job duties
- Avoid scheduling exams during busy season
- Focus on high-ROI topics
- Weekly progress check-ins to maintain momentum

## Retaker

### Profile
- Failed one or more sections
- May have passed sections with expiring credit
- Often frustrated or demoralized

### Needs
- Score report analysis (why did they fail?)
- Different strategy than first attempt
- 18-month window pressure awareness
- Psychological support and motivation
- Targeted study plan focusing on weak areas

### Agent Approach
- Analyze previous score reports in detail
- Compare study hours vs. topic performance
- Recommend changes: different course, different method, more/less time
- Calculate expiration deadlines prominently
- More frequent check-ins to prevent abandonment
- Celebrate small wins

## International Candidate

### Profile
- Degree from outside US
- May not have SSN
- IFRS background, unfamiliar with US GAAP

### Needs
- State selection guidance (which accept internationals)
- Education evaluation process (WES, FACS)
- GAAP vs IFRS differences
- International Prometric center information
- Visa/work authorization considerations

### Agent Approach
- Start with state eligibility research
- Guide through credential evaluation process
- Create GAAP-IFRS comparison flashcards
- Include Government/NFP as priority (unique to US)
- Factor in international testing fees and logistics

## Parent Supporting Child

### Profile
- Parent of CPA candidate
- Wants to understand process to provide support
- May be paying for review course

### Needs
- Understanding of exam structure and timeline
- Realistic expectations about time commitment
- How to support without micromanaging
- Progress visibility (with candidate permission)

### Agent Approach
- Provide high-level overview of CPA journey
- Set expectations: 9-18 months typical
- Explain what support helps (encouragement, time, space)
- If candidate shares access: provide periodic summaries

## CPA Tutor

### Profile
- Tutors multiple CPA candidates
- Needs to track multiple students
- May focus on specific sections

### Needs
- Multi-student tracking
- Comparative performance analysis
- Common weak areas across students
- Study material recommendations
- Progress reporting for students

### Agent Approach
- Maintain separate tracking per student
- Aggregate insights (e.g., "most students struggle with X")
- Generate student progress reports
- Suggest tutoring focus areas
- Track tutor's success rates by section

## Adaptation Triggers

| Detected Situation | Agent Response |
|-------------------|----------------|
| Failed same section twice | Recommend significant strategy change |
| Credit about to expire | Escalate urgency, adjust all plans |
| Busy season mentioned | Adjust study targets, defer exams |
| IFRS background detected | Prioritize GAAP differences |
| Low study hours logged | Check-in on motivation, obstacles |
| Practice scores improving | Encourage, suggest exam scheduling |
| Practice scores plateaued | Diagnose specific weak areas |
