# CPA Study Strategies

## Section Order Strategies

### Traditional: FAR First
- **Logic:** FAR is largest, hardest; get it done while fresh
- **Best for:** Full-time students, those with strong accounting foundation
- **Risk:** If you fail FAR, morale hit early

### Momentum: BEC First
- **Logic:** BEC is shortest, most conceptual; build confidence
- **Best for:** Working professionals, those returning to study after break
- **Risk:** May underestimate FAR difficulty later

### Experience-Based
- **Work in audit?** → AUD first (leverage daily experience)
- **Work in tax?** → REG first
- **Work in financial reporting?** → FAR first
- **Corporate accounting?** → BEC first

### Strategic Pairing
- **FAR + AUD:** Overlap in financial statement concepts
- **REG + BEC:** Both have business law elements
- **FAR + REG:** Tax accounting connects to financial accounting

## Study Approaches by Section

### FAR (Most Content)
- 6-8 weeks minimum for first-timers
- Focus on understanding, not memorizing
- Government/NFP is low-weight but trips people up
- Lease accounting changed recently—use updated materials

### AUD
- 4-6 weeks typical
- Memorize report language exactly
- Practice writing audit opinions
- If you work in audit, leverage that experience

### REG
- 5-7 weeks typical
- Tax law changes annually—use current year materials
- Individual tax is highest weight
- Business law is straightforward but easy to neglect

### BEC
- 4-5 weeks typical
- Written communication is free points if you practice
- Cost accounting calculations require practice
- Economics section is conceptual—don't overstudy

## Working Professional Strategy

### Time Management
- Study 15-20 hours/week minimum
- Early mornings before work (6-7:30 AM)
- Lunch breaks for flashcards
- Weekends for simulations and practice exams

### Busy Season Adjustments
- Don't schedule exams during busy season (Jan-April for tax, year-end for audit)
- Reduce study hours during crunch; don't stop entirely
- Use busy season to mentally "rest" one section, then return

### Leverage Work Experience
- If you see it at work, you'll remember it on the exam
- Journal entries you make daily are FAR content
- Audit procedures you perform are AUD content

## Retaker Strategy

### Analyze the Failure
- Score report shows weaker/comparable/stronger by area
- Compare to your study hours per topic
- Identify: did you understudy it, or just not understand it?

### Don't Restudy Everything
- "Stronger" areas need light review only
- "Weaker" areas need full re-learn
- "Comparable" areas need moderate review

### Change Something
- Same study method twice = same result
- Try different review course, different schedule, different approach
- Hammering method: repeat only questions you miss until 90%+ accuracy

### Timeline Pressure
- Calculate 18-month cliff
- If credits expiring soon, prioritize those sections
- Consider taking two sections close together if time is critical

## Review Course Comparison

| Course | Strengths | Best For |
|--------|-----------|----------|
| Becker | Comprehensive, proven track record | Traditional learners, employer-paid |
| Roger | Engaging lectures, humor | Those who struggle to stay focused |
| Surgent | Adaptive learning, efficient | Busy professionals, self-starters |
| Wiley | Unlimited access, affordable | Budget-conscious, multiple attempts |
| Gleim | Tons of MCQs | Those who learn by repetition |

## Practice Exam Strategy

- Take first practice exam early (week 2-3) to baseline
- Simulate real conditions: timed, no notes, no breaks
- Review EVERY wrong answer—understand why
- Target 75+ on practice exams before scheduling real exam
- Most courses' practice exams are harder than real thing
