# International CPA Candidates

## State Selection for Internationals

Not all states allow international candidates. Key factors:
- SSN requirement (some waive it)
- In-state experience requirement
- Education evaluation acceptance

### Recommended States for Internationals

| State | SSN Required? | Notes |
|-------|---------------|-------|
| Colorado | No | Popular for internationals |
| Montana | No | Lower requirements |
| Guam | No | US territory, often used by internationals |
| Illinois | No | Major state, accepts international credentials |
| Washington | No | No experience requirement to sit |
| New Hampshire | No | 120 credits to sit |

### States to Avoid
- New York: Requires SSN, strict requirements
- California: Lengthy process, experience requirements
- Texas: Requires SSN for license

## Education Evaluation

Your foreign degree must be evaluated for US equivalency.

### Evaluation Agencies
| Agency | Accepted By | Timeline |
|--------|-------------|----------|
| WES (World Education Services) | Most states | 2-3 weeks |
| FACS (Foreign Academic Credentials) | NASBA states | 3-4 weeks |
| NIES | Some states | 2-3 weeks |

### What They Evaluate
- Total semester credits (need 120 or 150 depending on state)
- Accounting credits (typically need 24-30)
- Business credits (typically need 24)

### Common Issues
- European ECTS ≠ US semester credits (150 ECTS ≈ 75-80 US credits)
- May need additional coursework to meet requirements
- Some countries' degrees don't translate well

## Taking the Exam Internationally

### Prometric International Centers
CPA exam available at Prometric centers in:
- Europe: London, Dublin, Frankfurt, others
- Middle East: Abu Dhabi, Dubai, Bahrain
- Asia: Tokyo, Seoul, Hong Kong, Mumbai
- Latin America: São Paulo, Mexico City

### Scheduling International
- Apply through your chosen US state board
- Once NTS approved, schedule at international Prometric
- Same exam as US—no modifications
- Additional international testing fee (~$390 per section)

### Visa Considerations
- Can take exam on B1/B2 tourist visa at international center
- For US centers, B1/B2 is acceptable for exam purposes
- No work visa needed to sit for exam
- License requirements (experience) may require work authorization

## GAAP vs IFRS Bridge

If your background is IFRS, focus on US GAAP differences:

### Revenue Recognition
- Converged (ASC 606 = IFRS 15), but watch for US-specific guidance

### Leases
- ASC 842 similar to IFRS 16 but US has finance vs. operating distinction for lessees

### Inventory
- US allows LIFO (IFRS prohibits)
- Lower of cost or market vs. lower of cost or NRV

### Key US GAAP Terms
| IFRS Term | US GAAP Term |
|-----------|--------------|
| Provisions | Contingencies |
| Revaluation model | Not allowed (cost model only) |
| IAS/IFRS | ASC (Accounting Standards Codification) |
| Profit or loss | Net income |

### Study Priority for IFRS Backgrounds
1. Government/NFP accounting (unique to US)
2. LIFO inventory
3. US-specific tax rules (REG)
4. AICPA professional standards
5. SEC reporting requirements

## Timeline for International Candidates

| Phase | Duration | Activities |
|-------|----------|------------|
| Research | 2-4 weeks | Choose state, understand requirements |
| Evaluation | 4-8 weeks | Submit transcripts, get credential evaluation |
| Application | 2-4 weeks | Apply to state board, pay fees |
| NTS Receipt | 2-6 weeks | Wait for Notice to Schedule |
| Study | 6-12 months | Prepare for all sections |
| Testing | 3-6 months | Take exams at international center |

Total: 12-18 months from start to completion (assuming no retakes)
