# CPA Exam Format

## The Four Sections

| Section | Name | Duration | Content Focus |
|---------|------|----------|---------------|
| AUD | Auditing and Attestation | 4 hours | Audit procedures, ethics, reports |
| BEC | Business Environment & Concepts | 4 hours | Corporate governance, economics, IT |
| FAR | Financial Accounting & Reporting | 4 hours | GAAP, government/NFP accounting |
| REG | Regulation | 4 hours | Tax law, business law, ethics |

## Question Types

### Multiple Choice Questions (MCQs)
- ~50% of score
- Adaptive difficulty (harder questions = more points)
- First testlet medium difficulty; second testlet adapts based on performance

### Task-Based Simulations (TBS)
- ~50% of score
- Real-world scenarios with research, calculations, written responses
- FAR and REG have more complex simulations

### Written Communication (BEC only)
- Part of BEC section
- Professional memo/letter writing
- Graded on organization, development, expression

## Scoring

- **Passing score:** 75 (scale of 0-99)
- **Score release:** ~2-3 weeks after testing window closes
- **Score report:** Shows performance by topic area (weaker/comparable/stronger)

## Testing Windows

Continuous testing year-round at Prometric centers. No blackout dates anymore (changed in 2020).

## 18-Month Rule

**Critical:** All 4 sections must be passed within an 18-month rolling window.

Example:
- Pass FAR: January 1, 2025
- Deadline to pass AUD, BEC, REG: July 1, 2026
- If you don't pass all by then, FAR credit expires and must be retaken

## Credit Expiration Tracking

| Section | Pass Date | Expires |
|---------|-----------|---------|
| FAR | Jan 1, 2025 | Jul 1, 2026 |
| AUD | Mar 15, 2025 | Sep 15, 2026 |
| ... | ... | ... |

**Agent should maintain this table in ~/cpa/passed/ and alert when <3 months remain.**

## Notice to Schedule (NTS)

- Valid for 6 months after issuance
- Covers sections you applied for
- If unused, must reapply and repay fees
- **Don't apply until you're ready to test within 6 months**

## Fees (Approximate)

| Item | Cost |
|------|------|
| Application (per section) | $50-100 |
| Exam fee (per section) | $200-250 |
| Ethics exam (some states) | $150-200 |
| License fee | $50-200 |

Total for all 4 sections: ~$1,500-2,500

## Content Blueprints

### FAR (most content-heavy)
- Conceptual Framework & Standards: 25-35%
- Financial Statement Accounts: 30-40%
- Transactions: 20-30%
- Government & NFP: 5-15%

### AUD
- Ethics, Independence: 15-25%
- Assessing Risk: 25-35%
- Performing Procedures: 30-40%
- Forming Conclusions: 10-20%

### REG
- Ethics & Responsibilities: 10-20%
- Business Law: 10-20%
- Federal Taxation: 55-85%

### BEC
- Corporate Governance: 17-27%
- Economics: 17-27%
- Financial Management: 11-21%
- IT: 15-25%
- Operations: 15-25%
