# OpenClaw JSONL 日志格式

本文档描述了 OpenClaw 会话日志文件的格式，特别是与费用计算相关的字段。

## 日志文件位置

OpenClaw 将会话日志存储在以下位置：

```
~/.openclaw/agents/{agent_id}/sessions/{session_id}.jsonl
```

在某些系统上，可能会通过符号链接指向：

```
~/.clawdbot/agents/{agent_id}/sessions/{session_id}.jsonl
```

## 文件格式

每个日志文件是 JSONL 格式（每行一个 JSON 对象）。每行记录一条消息、工具调用或系统事件。

## 费用相关字段

关键字段路径：

```
message.usage.cost.total       # 总费用
message.usage.cost.input       # 输入成本
message.usage.cost.output      # 输出成本
message.usage.cost.cacheRead   # 缓存读取成本
message.usage.cost.cacheWrite  # 缓存写入成本
```

## 示例记录

以下是一个包含费用信息的记录示例：

```json
{
  "type": "message",
  "id": "a08ab7f3",
  "parentId": "a60970bd",
  "timestamp": "2026-02-04T15:34:59.833Z",
  "message": {
    "role": "assistant",
    "content": [
      {"type": "text", "text": "我需要获取OpenClaw的使用费用数据。让我来为您查询当天的使用费用预估。"},
      {"type": "toolCall", "id": "toolu_01PUpUMycdh9bNYUcxG4wUS2", "name": "session_status", "arguments": {}}
    ],
    "api": "anthropic-messages",
    "provider": "anthropic",
    "model": "claude-3-7-sonnet-latest",
    "usage": {
      "input": 3,
      "output": 71,
      "cacheRead": 17138,
      "cacheWrite": 326,
      "totalTokens": 17538,
      "cost": {
        "input": 0.000009,
        "output": 0.001065,
        "cacheRead": 0.0051414,
        "cacheWrite": 0.0012225,
        "total": 0.007437899999999999
      }
    },
    "stopReason": "toolUse",
    "timestamp": 1770219296684
  }
}
```

## 特殊情况

1. **未包含费用数据**：某些记录可能不包含费用信息，如空消息、错误响应或免费模型。

2. **零成本模型**：某些模型（如本地模型）可能报告零成本。

3. **缓存机制**：OpenClaw 使用缓存机制减少重复 API 调用，缓存读写也有相应成本。

4. **错误响应**：API 调用失败的记录可能有 `errorMessage` 字段，但没有完整的 `usage` 或 `cost` 信息。

## 注意事项

- 避免通过 `totalTokens` 字段计算成本，因为不同的模型有不同的价格。
- 使用 jq 等工具解析 JSON 比使用文本正则表达式更可靠。
- 时区问题：`timestamp` 字段采用 ISO 格式，包含 UTC 时间，需要根据本地时区调整。