---
name: copywriting
description: Write persuasive copy for landing pages, emails, ads, sales pages, and marketing materials. Use when you need to write headlines, CTAs, product descriptions, ad copy, email sequences, or any text meant to drive action. Covers copywriting formulas (AIDA, PAS, FAB), headline writing, emotional triggers, objection handling in copy, and A/B testing. Trigger on "write copy", "copywriting", "landing page copy", "headline", "write a sales page", "ad copy", "email copy", "persuasive writing", "how to write [marketing text]".
---

# Copywriting

## Overview
Copywriting is not creative writing. It's strategic writing designed to move someone toward a decision. For solopreneurs, good copy can double conversion rates without changing anything else in your product or funnel. This playbook gives you frameworks and techniques to write copy that sells — without sounding sleazy.

---

## Step 1: Understand the Core Job of Copy

Copy exists to:
1. **Grab attention** (get them to stop scrolling)
2. **Create desire** (make them want what you're offering)
3. **Remove friction** (address doubts and objections)
4. **Prompt action** (tell them exactly what to do next)

Every piece of copy — a headline, a landing page, an email — must accomplish all four. If it fails at any one, the copy fails.

---

## Step 2: The Anatomy of Persuasive Copy

Effective copy follows a structure. The three most battle-tested frameworks:

### Framework 1: AIDA (Attention, Interest, Desire, Action)
Classic and reliable. Use for landing pages, emails, and sales pages.

```
ATTENTION:    Bold headline that stops the scroll (the promise or the pain)
INTEREST:     Elaborate on the problem or opportunity (make them nod "yes, that's me")
DESIRE:       Show the transformation or outcome (paint the picture of success)
ACTION:       Clear CTA (tell them exactly what to do next)
```

**Example (SaaS landing page):**
```
ATTENTION:    "Spend 10 hours/week on client reporting? Automate it in 10 minutes."
INTEREST:     "Most agencies waste entire days pulling data from 6 different tools
               into one report. Your clients don't care about your process — they
               want insights, fast."
DESIRE:       "Imagine sending polished, branded reports automatically every Monday.
               Your clients stay informed. Your team stays focused on the work that
               actually grows accounts."
ACTION:       "Start your free 14-day trial — no credit card required."
```

### Framework 2: PAS (Problem, Agitate, Solution)
Best for pain-driven products or when your audience is already aware of the problem.

```
PROBLEM:      State the problem clearly
AGITATE:      Make the pain feel urgent (what happens if they don't solve it?)
SOLUTION:     Present your product as the fix
```

**Example (email subject + body):**
```
PROBLEM:      "Your outreach emails are getting ignored."
AGITATE:      "Every unanswered email is a lost opportunity. The longer you wait to
               fix your messaging, the more revenue walks out the door."
SOLUTION:     "Our 5-step cold email framework gets 23% reply rates. Grab the
               template free."
```

### Framework 3: FAB (Features, Advantages, Benefits)
Best for explaining product value or differentiating from competitors.

```
FEATURE:      What the thing is or does (the fact)
ADVANTAGE:    Why that feature matters (the comparison)
BENEFIT:      What the customer gains from it (the outcome)
```

**Example (product description):**
```
FEATURE:      "Our tool syncs with 12 data sources in real time."
ADVANTAGE:    "Unlike competitors that sync once daily, you never work with stale data."
BENEFIT:      "Make confident decisions faster — no more second-guessing whether
               your numbers are current."
```

---

## Step 3: Write Headlines That Hook

The headline is 80% of the battle. If it doesn't grab attention, nothing else matters.

**Headline formulas that work:**

| Formula | Example |
|---|---|
| **The Promise** | "Double your email open rates in 30 days" |
| **The Question** | "Still wasting 10 hours/week on manual invoicing?" |
| **The How-To** | "How to automate your entire sales pipeline in one afternoon" |
| **The Number** | "7 mistakes killing your landing page conversions" |
| **The Negative** | "Stop losing leads to your broken signup flow" |
| **The Curiosity Gap** | "The one change that tripled our demo bookings" |
| **The Transformation** | "From 50 leads/month to 500 — here's what changed" |

**Rules for headlines:**
- Be specific. "Grow your business" is vague. "Add $10K MRR in 90 days" is specific.
- Lead with the outcome, not the method. "Save 10 hours/week" beats "Use our automation tool."
- Test multiple headlines. A/B test at minimum — even slight wording changes can double conversions.

---

## Step 4: Write CTAs That Convert

A weak CTA kills conversions even if everything else is perfect. Your CTA must be clear, specific, and low-friction.

**CTA best practices:**

**Bad CTAs:**
- "Submit" (generic, no motivation)
- "Click here" (doesn't say what happens next)
- "Learn more" (vague, non-committal)

**Good CTAs:**
- "Start my free trial" (specific, ownership language)
- "Get the template now" (actionable, clear value)
- "Book my strategy call" (personal, clear next step)

**CTA formula:** [Action Verb] + [What They Get] + [Urgency or Ease]

Examples:
- "Download the free checklist" (action + value + ease)
- "Claim your 14-day trial — no credit card needed" (action + value + friction removal)
- "Reserve my spot before Friday" (action + urgency)

**CTA placement:**
- Above the fold (so they don't have to scroll to act)
- After explaining value (don't ask before you've sold them)
- Multiple times on long pages (after each value section)

---

## Step 5: Use Emotional Triggers

Humans make decisions emotionally and justify them rationally. Tap into the emotions that drive buying behavior.

**Key emotional triggers in copy:**

| Trigger | When to Use | Example |
|---|---|---|
| **Fear of missing out (FOMO)** | Limited offers, scarcity | "Only 3 spots left this month" |
| **Fear of loss** | When the cost of inaction is high | "Every day without this, you're losing $X" |
| **Desire for status** | Aspirational products, B2B | "Join 10,000+ top-performing agencies" |
| **Desire for ease** | Replacing manual work | "Set it up once. Forget about it forever." |
| **Anger or frustration** | Replacing a broken solution | "Tired of tools that promise the world and deliver nothing?" |
| **Hope** | When the outcome feels out of reach | "Yes, you CAN hit $10K MRR as a solo founder" |

**Rule:** Use emotion to hook them, then use logic (features, proof, specifics) to justify the decision.

---

## Step 6: Handle Objections in Your Copy

Every prospect has doubts. Great copy addresses these doubts before they become blockers.

**Common objections and how to handle them in copy:**

| Objection | Copy Response |
|---|---|
| "It's too expensive" | Show ROI: "Pays for itself in 2 weeks based on time saved" |
| "It won't work for me" | Social proof: "Here's how [similar customer] got results" |
| "I don't have time to implement" | Ease claim: "Setup takes 10 minutes. We guide you through it." |
| "What if it doesn't work?" | Risk reversal: "30-day money-back guarantee. Zero risk." |
| "I need to think about it" | Urgency: "Price increases Friday" or scarcity: "Only 5 licenses left" |

**Where to place objection-handling copy:**
- In an FAQ section (addresses doubts explicitly)
- In testimonials (real customers answering the objection)
- Near the CTA (right before they decide)

---

## Step 7: Build Trust with Proof

Claims without proof are just noise. Proof makes your copy credible.

**Types of proof to include:**

1. **Testimonials:** Real quotes from real customers. Include their name, title, and company. Specificity = credibility.
2. **Case studies:** "Client X had Problem Y. We did Z. Result was [specific outcome]."
3. **Data:** Numbers, percentages, time saved, revenue generated. "Our users save an average of 12 hours/week."
4. **Social proof:** "Trusted by 5,000+ businesses" or "Featured in Forbes, TechCrunch."
5. **Certifications or credentials:** If you have relevant ones. "Certified HubSpot Partner" or "10 years building automation systems."

**Placement:** Sprinkle proof throughout the page. Don't dump it all in one section — intersperse it with your value propositions.

---

## Step 8: Test and Iterate

The first draft is never the best version. Copywriting improves through testing.

**What to A/B test:**
- Headlines (this usually has the biggest impact)
- CTAs (wording and placement)
- The order of value propositions (what you lead with)
- Length (sometimes shorter is better, sometimes longer converts more)
- Emotional tone (urgent vs calm, confident vs humble)

**Testing workflow:**
1. Write version A (your current best guess)
2. Write version B (change ONE variable — headline, CTA, or structure)
3. Run both versions to equal traffic for 7-14 days or until statistical significance
4. Keep the winner, test a new variable against it

**Rule:** Change one thing at a time. If you change the headline AND the CTA AND the layout, you won't know what caused the improvement.

---

## Copywriting Mistakes to Avoid
- Writing about features instead of benefits. Customers don't care what your product DOES — they care what it does FOR THEM.
- Being clever instead of clear. Clever headlines that confuse don't convert. Clarity always wins.
- Burying the value. Don't make them scroll to understand what you offer. Lead with the outcome.
- Using jargon or buzzwords. "Leveraging synergies to optimize workflows" means nothing. "Save 5 hours/week" does.
- Not having a single, clear CTA. If you give people 5 options, they'll pick none. One CTA per page.
- Writing for yourself, not your audience. Use THEIR language, address THEIR pain, promise THEIR desired outcome.
