# Pre-Flight Checklist

Run every piece of copy through this before it goes live. No exceptions.

---

## STRATEGY

- [ ] **One avatar.** This copy speaks to exactly one specific person — not a demographic range.
- [ ] **Awareness stage identified.** I know whether this reader is Unaware, Problem Aware, Solution Aware, Product Aware, or Most Aware — and the copy matches that stage.
- [ ] **Traffic temperature matched.** Cold traffic gets problem/story copy. Warm traffic gets proof/differentiation. Hot traffic gets the close.
- [ ] **Enters their conversation.** The opening line reflects what the reader is already thinking, feeling, or experiencing — not what I want to say about my product.
- [ ] **One goal.** This piece of copy has one purpose. It does not try to educate, sell, entertain, and build brand awareness simultaneously.

---

## STRUCTURE

- [ ] **Framework applied.** I used AIDA, PAS, BAB, or another proven framework — not free-form writing.
- [ ] **Headline is strong.** It has at least 2 of the 4 U's: Useful, Urgent, Unique, Ultra-specific.
- [ ] **No buried lede.** The most compelling thing is first — not in paragraph 3.
- [ ] **Offer mapped to TIMER.** If this copy includes an offer, I identified the top 2 TIMER levers (Time, Identity, Money, Ego, Reputation) and led with them.
- [ ] **Logical flow.** The copy moves the reader forward — each section earns the next.

---

## LANGUAGE

- [ ] **Grade 6 reading level.** Pasted into Hemingway Editor. No red sentences. Few yellow ones.
- [ ] **Short sentences.** Average sentence length ≤14 words.
- [ ] **Small words.** Replaced "utilize" with "use," "purchase" with "buy," etc.
- [ ] **Empathy leads.** The opening enters the reader's world — it does not start with "We are…"
- [ ] **Their language.** I used the exact phrases and words the target avatar uses — not industry jargon or my internal language.
- [ ] **Sounds human.** I read it out loud. It sounds like a real person talking, not a brochure.
- [ ] **Active voice.** Passive constructions converted. No "will be provided," "can be seen," etc.
- [ ] **Filler removed.** Cut "in order to," "due to the fact that," "we are committed to excellence," etc.
- [ ] **More "you" than "we."** Reader-centric. Not brand-centric.

---

## PERSUASION

- [ ] **Specific.** Every claim has a number, name, or proof. No vague superlatives.
- [ ] **Social proof.** Testimonials, reviews, case studies, or client counts included.
- [ ] **Risk reversal.** A guarantee or "no-risk" statement is present to remove fear of action.
- [ ] **Urgency or scarcity.** If present, it is real — not manufactured. Fake urgency destroys trust.
- [ ] **Benefits, not features.** Every feature is translated to what it means for the reader.
- [ ] **Loss aversion framed.** Where relevant, the copy frames inaction as a cost — not just action as a gain.
- [ ] **Psychological triggers layered.** At least 2–3 of: reciprocity, social proof, authority, scarcity, urgency, loss aversion, specificity.

---

## CALL TO ACTION

- [ ] **One ask.** The copy ends with exactly one CTA. Not two options. Not "or you can also…"
- [ ] **Starts with a verb.** "Book," "Get," "Claim," "Start," "Download," "Try."
- [ ] **Names the specific outcome.** Not "Click Here" — "Get My Free Lawn Assessment."
- [ ] **Reduces friction.** If possible: how long it takes, what happens next, no-obligation language.
- [ ] **Reinforces the benefit.** "Start Saving $80/Month Today" not just "Submit."

---

## FORMAT (for long-form copy)

- [ ] **Paragraphs ≤3 sentences.** No walls of text.
- [ ] **Subheadings every ~150–200 words.** Written as benefits, not labels.
- [ ] **Bullets for lists.** 3+ items become bullets. Each starts with a verb or benefit.
- [ ] **Bold key phrases.** Scan-reading tells the basic story.
- [ ] **White space.** Enough breathing room between sections.

---

## FINAL SANITY CHECK

Ask yourself these questions:

1. **"So what?"** — Would my ideal customer read this and think "so what?" If yes, add a benefit.
2. **"Who cares?"** — Is this relevant to this specific avatar? If not, cut it.
3. **"Prove it"** — Is there a claim here that a skeptic would challenge? If yes, add proof.
4. **"Could anyone else say this?"** — If a competitor could swap their logo onto this copy, it's not differentiated enough.
5. **"What do I do?"** — Is the next action crystal clear? No ambiguity?

---

## Scoring Guide

Count your checkmarks.

| Score | Status |
|---|---|
| 30–33 ✅ | Publish. This is strong copy. |
| 22–29 ✅ | One more pass. Fix the misses, then publish. |
| Under 22 ✅ | Rewrite. The foundation isn't solid. |

---

*This checklist applies to: ads, emails, landing pages, sales pages, social posts, product descriptions, CTAs, video scripts, and any other persuasive copy.*
