# Language & Readability Rules

## The Prime Directive

Write the way people talk. Not the way people write reports.

If you read your copy out loud and it sounds like a brochure, a press release, or a corporate memo — rewrite it. The bar is: could you say this over coffee to a friend and not sound weird?

---

## Readability Targets

| Metric | Target | Why |
|---|---|---|
| Flesch-Kincaid Grade Level | 5–7 | Most Americans read at a Grade 7 level; writing below it removes friction |
| Flesch Reading Ease | 60–70 | Higher = more readable; 60–70 is "standard" for a general audience |
| Avg. sentence length | ≤14 words | Studies show 90%+ comprehension at 14 words; drops to 10% at 43 words |
| Avg. word length | ≤5 characters | Shorter words process faster and feel more confident |

**Tools:** [Hemingway Editor](https://hemingwayapp.com) (free, paste your copy)

---

## Rule 1: Short Sentences

One idea. One sentence. Period.

**Wrong:**
> "Our team of experienced, certified, and award-winning landscape designers will come to your home and conduct a thorough assessment of your property before crafting a customized plan tailored specifically to your needs and budget."

**Right:**
> "We come to you. We assess your property. Then we build a plan — for your space, your budget, and your goals."

**How to fix long sentences:**
- Find the "and" — split it there
- Find the "which" or "that" — often signals a new sentence
- If a sentence has more than 2 commas, it's probably 2 sentences

---

## Rule 2: Small Words Win

Replace every polysyllabic word with the shortest word that means the same thing.

| Replace This | With This |
|---|---|
| Utilize | Use |
| Facilitate | Help |
| Demonstrate | Show |
| Commence / Initiate | Start |
| Terminate | End |
| Purchase | Buy |
| Approximately | About |
| Sufficient | Enough |
| Implement | Do |
| Subsequent | Next |
| Endeavor | Try |
| Leverage (as a verb) | Use |
| Prioritize | Focus on |
| Synergize | Work together |
| Optimal | Best |
| Ascertain | Find out |
| Modification | Change |
| Assistance | Help |
| Inform | Tell |
| Provide | Give |
| Obtain | Get |
| Require | Need |
| Regarding | About |

---

## Rule 3: Empathy First — Enter Their World

Your reader does not care about you. They care about themselves. Your copy's job is to make them feel understood *before* you ask them to trust you.

**Wrong (self-centered):**
> "We are a family-owned landscaping company founded in 2009 with 50+ team members and over 500 completed projects…"

**Right (reader-centered):**
> "You deserve an outdoor space that makes you proud to come home. Not a constant source of stress, embarrassment, or wasted weekends."

**The empathy formula:**
> Start with what they're feeling → validate it → then introduce yourself.

**Lead sentence patterns that pass the empathy test:**
- "You've been [struggling with X] long enough."
- "Most [avatar] tell us the same thing: [their exact problem in their words]."
- "If you've ever [painful situation], you know exactly how frustrating it is."
- "There's nothing worse than [specific relatable pain]."
- "You work hard. You shouldn't have to [painful thing] on top of it."

---

## Rule 4: Specificity = Credibility

Vague copy triggers skepticism. Specific copy triggers belief.

The brain is wired to trust specifics. Round numbers and generic phrases feel like marketing. Odd numbers and precise details feel like truth.

| ❌ Vague (weak) | ✅ Specific (strong) |
|---|---|
| "Fast results" | "See results in 7 days or less" |
| "Many happy customers" | "487 five-star Google reviews" |
| "Save money" | "Cut your water bill by $73/month on average" |
| "Years of experience" | "15 years and 512 completed projects" |
| "High quality materials" | "Built with commercial-grade bluestone rated for 40+ years" |
| "Trusted by businesses" | "Trusted by 230 Portland-area businesses since 2009" |
| "Quick turnaround" | "Most jobs completed within 72 hours of approval" |
| "Satisfaction guaranteed" | "100% money back within 30 days — no questions asked" |

**The specificity test:** Read your claim. Could it appear in any competitor's brochure? If yes, make it more specific.

---

## Rule 5: Use Their Language — Not Yours

The best copy uses the exact words your customer uses to describe their problem.

**How to find their language:**
- Read Amazon/Yelp/Google reviews for your category
- Mine Reddit threads where your avatar asks for help
- Review support tickets and chat logs
- Read survey responses word-for-word
- Listen to sales call recordings and write down their phrases

**What to look for:**
- The specific word they use for the problem ("patchy," "yellow," "dead," "embarrassing")
- The metaphors they reach for ("looks like a jungle," "just gave up")
- The emotion they express ("embarrassed," "fed up," "wasted so much money")
- What they wish existed ("I just want someone I can trust")

**Example — lawn care:**
- They say: "my lawn looks patchy and embarrassing"
- You write: "Is your lawn patchy and embarrassing?" (not: "Is your lawn aesthetically suboptimal?")

---

## Rule 6: Active Voice Over Passive

Active voice is shorter, clearer, and more confident.

| ❌ Passive | ✅ Active |
|---|---|
| "Your lawn will be transformed by our team" | "Our team transforms your lawn" |
| "Results can be seen within 7 days" | "See results in 7 days" |
| "A free quote will be provided" | "We give you a free quote" |
| "It is recommended that you…" | "We recommend you…" |

**How to spot passive voice:** If you can add "by zombies" to the sentence and it makes grammatical sense, it's passive.
> "Your lawn will be transformed by zombies." → passive. Fix it.

---

## Rule 7: Formatting for Scannability

People scan before they read. Give them entry points.

- **Short paragraphs.** 1–3 sentences. Never more than 5 lines of text in a block.
- **Subheadings every 150–200 words** — written as benefits, not labels
- **Bullet points** for lists of 3+ items — each bullet starts with a verb or benefit
- **Bold key phrases** — the scan should tell the basic story
- **White space** — is not wasted space. It's breathing room that helps comprehension.
- **No full justification** — left-aligned text is easier to read

---

## Rule 8: Eliminate Filler Phrases

These words add length but subtract clarity. Cut them ruthlessly.

| Filler | Replacement |
|---|---|
| "In order to" | "To" |
| "Due to the fact that" | "Because" |
| "At this point in time" | "Now" |
| "In the event that" | "If" |
| "For the purpose of" | "To" |
| "It is important to note that" | (just say the thing) |
| "As previously mentioned" | (just say it again or cut it) |
| "The fact that" | (restructure the sentence) |
| "Needless to say" | (if needless to say — don't say it) |
| "We are committed to excellence" | (prove it with specifics instead) |
| "We are passionate about" | (nobody believes this) |
| "Best in class" | (prove it with a real claim) |
| "World-class" | (same — prove it) |

---

## Rule 9: Lead with "You," Not "We"

Count how many times your copy says "we" vs. "you."

Every "we" should be converted to a "you" wherever possible.

| ❌ We-focused | ✅ You-focused |
|---|---|
| "We offer free consultations" | "You get a free consultation" |
| "We have 15 years of experience" | "You get 15 years of expertise working for your property" |
| "We are proud to serve Portland" | "Portland homeowners have trusted us for 15 years" |
| "We guarantee our work" | "Your satisfaction is guaranteed — or we redo it free" |

---

## Rule 10: The Rhythm Test

Good copy has rhythm. Vary your sentence length intentionally.

Short sentences hit hard.

Slightly longer ones give context and let the idea breathe before you land the next point.

Short again. Boom.

This variation keeps the reader moving forward. Flat sentences all the same length — like this one, which is twenty words long and keeps going past where it should have stopped — put people to sleep.

Read your copy out loud. Where you trip up is where the reader will tune out. Fix those spots.

---

## Quick Diagnostic — Warning Signs in Copy

If you see any of these, the copy needs work:

- ❌ Opens with "We are…" or "Our company…"
- ❌ Has a sentence longer than 25 words
- ❌ Uses the word "leverage" as a verb
- ❌ Claims to be "best in class" or "world-class" without proof
- ❌ Bullet points all start with the same word
- ❌ Zero numbers or statistics
- ❌ No testimonials or social proof
- ❌ More "we/our" than "you/your"
- ❌ No clear single CTA at the end
- ❌ Would make zero sense to someone outside your industry
