# Awareness Stages & Copywriting Frameworks

## Table of Contents
1. The 5 Stages of Awareness
2. AIDA
3. PAS
4. BAB (Before–After–Bridge)
5. FAB (Features–Advantages–Benefits)
6. The 4 C's Quality Check
7. TIMER Offer Framework

---

## 1. The 5 Stages of Awareness (Eugene Schwartz, *Breakthrough Advertising*, 1966)

The most important concept in all of copywriting. Match your message to where the reader IS — not where you want them to be.

| Stage | What They Know | Messaging Job | Lead With |
|---|---|---|---|
| **1 — Unaware** | No idea they have a problem | Educate. Plant the seed. No selling. | A story, a shocking fact, a "did you know?" |
| **2 — Problem Aware** | Knows the pain, not the fix | Amplify the problem. Show the cost of inaction. | Their pain in their own words |
| **3 — Solution Aware** | Knows fixes exist, not yours | Prove your approach works. Compare. | Case study, proof, mechanism |
| **4 — Product Aware** | Knows you, hasn't bought | Differentiate. Crush objections. Stack value. | Offer details, guarantee, bonuses |
| **5 — Most Aware** | Ready to buy, needs a nudge | Close. Give the final push. | Urgency, deadline, deal, guarantee |

### Traffic → Stage Mapping

| Traffic Type | Awareness Stage | Copy Entry Point |
|---|---|---|
| Cold (paid ads, cold social, billboards) | 1–2 | Open with problem/story — never with product |
| Warm (email list, podcast, blog) | 3–4 | Open with proof/differentiation |
| Hot (retargeting, sales call follow-up, checkout) | 5 | Open with the deal and guarantee |

### Unaware Copy (Stage 1) — Rules
- **No selling.** Education only. Selling here destroys trust.
- Goal: create an "aha" moment about a problem they didn't know they had.
- Give away a free resource. Create engagement for retargeting.
- Example ad angle: *"The hidden reason most lawns die in summer (it's not what you think)"*

### Problem Aware Copy (Stage 2) — Rules
- Rub the wound. Make them feel the full weight of their problem.
- Use their exact words. Mirror their internal dialogue.
- Don't introduce your solution yet — they're not ready.
- Example ad angle: *"You've tried every fertilizer and nothing works. Here's why."*

### Solution Aware Copy (Stage 3) — Rules
- They know solutions exist. Now they need to trust *your* mechanism.
- Lead with proof: before/afters, statistics, testimonials, case studies.
- Position your approach as superior *without* attacking competitors.
- Example ad angle: *"How we restored 500+ Portland lawns using a 3-step soil method."*

### Product Aware Copy (Stage 4) — Rules
- They know you. Address the objection stopping them from buying.
- Stack the value. Restate benefits. Add bonuses.
- Make the offer feel irresistible, not just affordable.
- Example: *"Still on the fence? Here's what's included + our 30-day guarantee."*

### Most Aware Copy (Stage 5) — Rules
- Get out of their way. They want to buy. Don't overthink the copy.
- Create real urgency or scarcity. Be direct.
- Lead with the deal, not the features.
- Example: *"Spring spots fill fast. Book this week and save $100."*

---

## 2. AIDA Framework

**Best for:** Ads, cold emails, landing pages, sales letters, social media posts, video scripts

The classic framework. Creates a journey from first impression to final decision.

| Step | Job | How to Write It |
|---|---|---|
| **A — Attention** | Stop the scroll or the skip | Bold claim, shocking stat, curiosity hook, direct call-out to the ICP |
| **I — Interest** | Make them want to keep reading | Story, relevant insight, "here's why this matters to YOU specifically" |
| **D — Desire** | Make them want the outcome | Benefits (not features), transformation story, social proof, paint the "after" |
| **A — Action** | Make them do one thing | Single clear CTA. Verb-led. One ask only. |

### AIDA Example — Landscaping Email

> **Attention (subject line):** "Why your lawn looks worse every spring (and how to fix it for good)"
>
> **Interest (opening):** "Most homeowners add more fertilizer hoping it'll work this time. But the soil underneath is usually the real problem — and fertilizer alone can't fix it."
>
> **Desire (body):** "Our Spring Soil Reset program corrects the underlying pH and compaction issues first. That's why our clients see results in 2 weeks while their neighbors keep reseeding. Here's what 3 of them said last April: [testimonials]"
>
> **Action (CTA):** "Book your free soil assessment before April 15 →"

### AIDA Mistakes to Avoid
- Starting with "We" (nobody cares about you yet)
- Jumping to action before desire is built
- Multiple CTAs (dilutes the ask)
- Desire section listing features instead of benefits

---

## 3. PAS Framework

**Best for:** Short ads, hero copy, email opens, social posts, situations where pain is high and obvious

| Step | Job | How to Write It |
|---|---|---|
| **P — Problem** | Name the pain directly and specifically | "Tired of…" / "Struggling with…" / "Here's what's happening…" |
| **A — Agitate** | Deepen the wound — make the cost of inaction real | Show what life looks like if nothing changes. Emotional consequences. Financial consequences. Social consequences. |
| **S — Solution** | Save them with your offer | Introduce your product/service as the clear, logical, obvious answer |

> **The Agitate step is where 90% of copy fails.** Most writers skip from problem to solution with no tension. Without real emotional build-up, there's no urgency to act. Sit in the agitation longer than feels comfortable.

### PAS Example — Plumbing Company Ad

> **Problem:** "Nothing is worse than a burst pipe on a Sunday night."
>
> **Agitate:** "Water spreading across your floor. Damage piling up by the minute. Your insurance deductible about to spike. And most plumbers? They don't answer on weekends. You're on your own — with a growing disaster."
>
> **Solution:** "Green Valley Plumbing is open 24/7 — and we answer in 3 rings or the call is free. We'll have a licensed plumber at your door within the hour."

### PAS Agitation Angles (pick the most relevant for your avatar)
- **Financial:** "Every day you wait costs you more."
- **Emotional:** "The embarrassment/frustration/stress compounds."
- **Social:** "Others will notice. Your reputation suffers."
- **Time:** "You're burning hours on this that you'll never get back."
- **Health/Safety:** "The longer you ignore it, the worse the damage."
- **Opportunity:** "Your competitors are doing this while you're still deciding."

---

## 4. BAB Framework (Before–After–Bridge)

**Best for:** Testimonials, case studies, transformation-based services, before/after proof, social media transformation posts

| Step | Job |
|---|---|
| **Before** | Paint the painful current reality. Be specific. Make it relatable. |
| **After** | Paint the dream outcome. Be vivid. Make it desirable. |
| **Bridge** | Present your product/service as the only path from Before to After. |

This is the fundamental structure of every hero's journey and every great case study.

### BAB Example — Gym / Fitness

> **Before:** "Six months ago, Mark couldn't make it up a flight of stairs without getting winded. He'd tried 3 different diets, canceled two gym memberships, and felt worse every year."
>
> **After:** "Today, Mark runs a 5K three mornings a week, fits into clothes from 10 years ago, and tells us he has more energy at 48 than he did at 35."
>
> **Bridge:** "The difference was our 90-Day Metabolic Reset Program — built around the specific challenges adults over 40 face."

### BAB Rules
- The "Before" must sting. If the reader doesn't feel it, the "After" won't matter.
- The "After" must be specific and credible — not fantasy.
- The "Bridge" is the only time you talk about your product.

---

## 5. FAB Framework (Features–Advantages–Benefits)

**Best for:** Product descriptions, bullet points on sales pages, comparison tables, service listings

Features describe what something IS. Benefits describe what it DOES FOR THE CUSTOMER. Always end at benefits.

| Level | Question | Example (Irrigation System) |
|---|---|---|
| **Feature** | What is it? | "Smart weather-sensing controller" |
| **Advantage** | What does it do? | "Automatically adjusts watering based on rain forecasts" |
| **Benefit** | What does it mean for me? | "Your lawn stays healthy without you ever touching the timer — and your water bill drops by up to 30%" |

### The "So What?" Test

For every feature, ask "So what?" twice:
- Feature: "Wi-Fi enabled"
- So what? → "You can control it from your phone"
- So what? → "You can turn it off from work if it starts raining, without coming home"

The second answer is almost always the real benefit.

### FAB Bullet Format

Write bullets as: **[Feature] that [Advantage] so you [Benefit]**
> "Smart scheduling that adjusts to weather forecasts, so you never overwater or pay for rain you didn't need."
> "Hardened steel blades that stay sharper 4x longer, so you spend less time sharpening and more time finishing."

---

## 6. The 4 C's — Copy Quality Checklist

Use this to review every piece of copy before publishing. Every "C" must pass.

| C | Question to Ask | Common Failure |
|---|---|---|
| **Clear** | Would a 12-year-old immediately understand this? | Jargon, passive voice, complex sentence structure |
| **Concise** | Can any word be cut without losing meaning? | Filler phrases ("in order to," "the fact that," "due to the fact that") |
| **Compelling** | Does it create emotion? Does it make them feel something? | Listing features without benefits, no story, no tension |
| **Credible** | Is it backed by proof? | Vague claims ("high quality," "best in class") without numbers or evidence |

**Target readability:** Grade 5 (Hemingway Editor). If it highlights red sentences, shorten them.

---

## 7. TIMER Offer Framework

Use when writing about any offer, product, service, deal, or program. Map the offer to its strongest levers before writing a word.

| Letter | Lever | Core Human Drive | Copy Angle |
|---|---|---|---|
| **T — Time** | Deadline / scarcity | Loss aversion: people fear losing more than gaining | "Only available until Friday midnight" / "3 spots left this month" |
| **I — Identity** | Who they want to become | Self-concept and aspiration | "This is for people who refuse to settle for average" / "Join the top 5% of lawn owners in Portland" |
| **M — Money** | Financial gain or loss | Security and abundance | "Saves you $400/month" / "Turn this skill into $10K/mo" / "Stop paying for overwatering" |
| **E — Ego** | Status and recognition from peers | Desire to look good and gain respect | "Be the neighbor everyone asks for lawn advice" / "The garden guests always comment on" |
| **R — Reputation** | Protect what they've built | Fear of embarrassment or loss | "Never risk your property looking neglected again" / "Protect your home's curb appeal and resale value" |

### How to Use TIMER

1. Write each lever as it applies to your specific offer
2. Pick the top 2 that are strongest for your avatar
3. Lead your offer copy with those 2 levers
4. Weave in the others as supporting copy

### TIMER Example — Landscaping Seasonal Package

> **T:** "Spring slots fill by March 31. After that, we're booked until June."
> **I:** "For homeowners who take pride in their property year-round — not just when it's convenient."
> **M:** "Clients on our seasonal program spend 40% less annually than those who call us for emergency fixes."
> **E:** "Your lawn will be the one neighbors stop to photograph. Seriously — it happens all the time."
> **R:** "Curb appeal directly impacts your home's resale value. Don't let neglect cost you tens of thousands at closing."

---

## Framework Quick Selector

| Situation | Best Framework |
|---|---|
| Cold traffic — they don't know you | PAS or Awareness Stage 1–2 story hook |
| Warm traffic — they know the problem | AIDA |
| Hot traffic — they know you, haven't bought | AIDA with heavy Desire + Stage 4–5 close |
| Short ad (social, display) | PAS |
| Full landing page | AIDA |
| Case study or testimonial | BAB |
| Product feature bullets | FAB |
| Any offer description | TIMER |
| Copy review / editing | 4 C's |
