---
name: copywriting
description: Write persuasive, high-converting copy for any format — ads, landing pages, emails, sales pages, headlines, product descriptions, CTAs, and social posts. Applies professional copywriting SOPs including avatar/ICP development, Voice of Customer research, Eugene Schwartz's 5 Stages of Awareness, AIDA, PAS, BAB, FAB frameworks, the TIMER offer framework, readability rules (Grade 6, ≤14 words/sentence), psychological triggers (scarcity, social proof, loss aversion, reciprocity), and the 4 C's quality checklist. Use when a user asks to write, improve, rewrite, or review any marketing or sales copy.
---

# Copywriting Skill

Produces high-converting copy using proven professional SOPs. Follow this skill in order — research before writing, framework before words, checklist before publishing.

## Core Principle

> Great copy is never written. It's discovered. Your job is to find the words your buyer already uses — then play them back.

## Workflow

### Step 1 — Research & Avatar (before writing anything)

Ask or determine:
- Who is the ONE specific person this is written for? (Not a demographic range — one person with a name)
- What is their awareness stage? (See `references/awareness-and-frameworks.md`)
- What exact words do they use to describe their problem?

**If VoC data is available** (reviews, testimonials, interviews, support tickets): mine it for exact phrases. Use their words, not yours.

**Avatar must-knows:**
- What keeps them up at 3am?
- What have they already tried that failed?
- What's their dream outcome?
- What objection will they raise before buying?

### Step 2 — Pick the Right Framework

| Writing... | Use |
|---|---|
| Cold ad / social post | PAS or Awareness Stage 1–2 hook |
| Landing page / sales page | AIDA (full) |
| Email subject line | Curiosity gap or number headline formula |
| Product bullets | FAB (Features → Advantages → Benefits) |
| Testimonial / case study | BAB (Before → After → Bridge) |
| Offer description | TIMER lever mapping |
| Any copy quality review | 4 C's checklist |

Full framework details + examples: `references/awareness-and-frameworks.md`

### Step 3 — Write the Headline First

Spend 50% of your effort here. 80% of readers read only the headline.

Every strong headline has ≥2 of the **4 U's**: Useful, Urgent, Unique, Ultra-specific.

Top formulas:
- `How to [Outcome] Without [Fear/Objection]`
- `[Number] [Things] [ICP] Should Know About [Topic]`
- `[Common Belief] — But Here's What They Don't Tell You`
- `[Outcome] in [Timeframe] — Or [Guarantee]`
- `If You [Problem], Then [Solution]`
- `Are You [Experiencing Painful Problem]?`

### Step 4 — Write the Body

Apply framework structure. Layer in psychological triggers throughout:

| Trigger | How |
|---|---|
| Social proof | Exact numbers: "487 five-star reviews" |
| Scarcity | Real limits: "3 spots left in April" |
| Urgency | Real deadline: "Offer ends Friday" |
| Loss aversion | Frame as loss avoided: "Stop losing $X/month" |
| Risk reversal | Guarantee: removes fear of being wrong |
| Reciprocity | Give value first — people feel compelled to return it |
| Authority | Credentials, awards, years, certifications |
| Specificity | Exact numbers = credibility; round numbers = skepticism |

### Step 5 — Language Rules (Non-Negotiable)

- **Grade 6 reading level** — Flesch-Kincaid 5–7. Use Hemingway Editor.
- **≤14 words per sentence** — comprehension drops sharply above this
- **Small words win** — "use" not "utilize," "show" not "demonstrate," "buy" not "purchase"
- **Specificity wins** — "cut your bill by $80/month" not "save money"
- **Empathy first** — enter their world before talking about you
- **Their language** — use the exact phrases from VoC research, not industry jargon
- **Read it out loud** — if it sounds like a brochure, rewrite it

Full language rules + small-word swap table: `references/language-and-readability.md`

### Step 6 — Write the CTA

One ask. Always one.

Formula: `[Action Verb] + [Specific Outcome] + [Time/Ease Qualifier]`

Examples:
- "Book Your Free Lawn Audit — Takes 2 Minutes"
- "Get My Custom Plan Today — No Obligation"
- "Claim Your Spot Before Friday"

### Step 7 — Run the Pre-Flight Checklist

Before any copy goes live, verify:

**Strategy:** One avatar? Awareness stage matched? Enters their conversation?
**Structure:** Framework applied? Offer maps to TIMER? Headline has 2+ U's?
**Language:** Grade 6? Short sentences? Small words? Sounds human? Uses their language?
**Persuasion:** Specifics? Social proof? Risk reversal? Real urgency?
**CTA:** One ask? Verb-led? Names the outcome?

Full checklist with all items: `references/preflight-checklist.md`
