# UX Writing Patterns

## Button Labels

```typescript
// Bad: Vague
<Button>Submit</Button>
<Button>OK</Button>

// Good: Verb + Noun, shows outcome
<Button>Create Account</Button>
<Button>Save Changes</Button>
<Button>Start Free Trial</Button>
```

## Error Messages

Formula: What happened → Why → How to fix

```typescript
// Bad
"Invalid input"
"Error 422"

// Good
"Please enter a valid email address"
"Password must be at least 8 characters"
```

## Empty States

Formula: Headline → Explanation → Action

```typescript
<EmptyState
  title="No results found"
  description="Try adjusting your search or filters"
  action={<Button>Clear Filters</Button>}
/>
```

## Form Labels

```typescript
<Label>
  Email Address
  <HelpText>We'll never share your email</HelpText>
</Label>
```

## Loading States

```typescript
// Bad: "Loading..."
// Good: "Creating your account..." / "Uploading (2/5)..."
```

## Success Messages

```typescript
<Toast
  message="Post published!"
  action={<Button>View Post</Button>}
/>
```

## Tooltips

```typescript
// Bad: Repeats label
<Tooltip content="Click to delete">

// Good: Adds context
<Tooltip content="This action cannot be undone">
```

## Confirmation Dialogs

```typescript
<Dialog
  title="Delete this post?"
  message="This will be permanently deleted."
  confirmButton="Delete Post"
  variant="destructive"
/>
```

## Placeholder Text

```typescript
// Bad: "Enter value"
// Good: "e.g., john@example.com"
```
