# Marketing Copy Patterns

## Hero Section

```typescript
<Hero>
  {/* Headline: Main benefit */}
  <h1>Deploy your app in seconds, not hours</h1>

  {/* Subheadline: How/Who */}
  <p>Push your code and we'll handle deployment, scaling, monitoring.</p>

  {/* CTA */}
  <Button>Start Free Trial</Button>
  <Button variant="outline">Watch Demo (2 min)</Button>

  {/* Social proof */}
  <p>Trusted by 50,000+ developers at Airbnb, Netflix, Shopify</p>
</Hero>
```

## Feature Descriptions

Focus on benefits, not features. Be specific (numbers, timeframes).

```typescript
const features = [
  {
    title: 'Lightning-Fast Deploys',
    description: 'See it live in under 30 seconds. No config files.'
  },
  {
    title: 'Auto-Scaling',
    description: 'Handle any traffic spike. Scale from zero to millions.'
  }
]
```

## Call-to-Action (CTA)

| Type | Example |
|------|---------|
| Value-focused | "Start Free Trial", "Get Started Free" |
| Urgency | "Claim Your Spot", "Join 10,000 Developers" |
| Low commitment | "Browse Templates", "See How It Works" |

Formula: Verb + Benefit + Remove friction ("Free", "No credit card")

## Email Templates

### Welcome Email

```typescript
<Email>
  <Heading>Welcome, {name}!</Heading>
  <Text>Here's what to do next:</Text>
  <ol>
    <li>Connect your Git repository</li>
    <li>Deploy your first project (2 min)</li>
    <li>Invite your team</li>
  </ol>
  <Button>Deploy Your First Project</Button>
</Email>
```

### Transactional Email

```typescript
<Email>
  <Heading>Payment Successful</Heading>
  <Text>We've received your payment of {total}.</Text>
  <Text>Order: {orderNumber}</Text>
  <Button>View Order Details</Button>
</Email>
```
