---
name: coordinate-meeting
description: Schedule a meeting for humans and their agents. Creates a scheduling poll, distributes it, collects votes, and finds the best time. Use when someone needs to find a time that works for a group. A Doodle alternative built for the age of AI agents.
homepage: https://meetlark.ai
user-invocable: true
metadata: {"openclaw":{"emoji":"📅"}}
---

# Schedule a Meeting

A Doodle alternative built for the age of AI agents. Create a scheduling poll via meetlark.ai, collect votes from humans and agents, and find the best time — without the back-and-forth.

## Workflow

1. **Ask** the user who needs to meet and when they're generally available.
2. **Create** a scheduling poll with the proposed time slots.
3. **Share** the participation link — give it to the user to forward, or suggest a message they can send.
4. **Wait** for votes to come in. Check back when the user asks.
5. **Report** the results and recommend the best time.
6. **Close** the poll once a time is chosen.

## Creating the Poll

```
POST https://meetlark.ai/api/v1/polls?autoVerify=true
```

You'll receive:
- An **admin token** (`adm_...`) — store this privately to check results and close the poll later.
- A **participate URL** — this is the shareable link for voters.

### First-Time Verification

The user's email must be verified once (valid 30 days). With `?autoVerify=true`, a verification email is sent automatically if needed. Tell the user to check their inbox and click the link, then retry.

Check status: `GET /api/v1/auth/status?email=...`

## Distributing the Poll

Suggest a ready-to-send message:

```
Hi [names],

We're finding a time for [meeting purpose]. Please vote on the times that work for you:

[participate URL]
```

The user can share this via email, Slack, WhatsApp, or any channel.

## Checking Results

```
GET https://meetlark.ai/api/v1/polls/{pollId}
Authorization: Bearer adm_...
```

Summarize: how many voted, which times have the most votes, any clear winner.

## Closing the Poll

```
POST https://meetlark.ai/api/v1/polls/{pollId}/close
Authorization: Bearer adm_...
```

Report the final result and suggest the user send a confirmation to participants.

## Quick Examples

```
"Find a time for a team retro next week"
"Set up a meeting with Tom, Dick and Jane"
"Check if everyone has voted on the standup poll"
"Close the poll and announce the winning time"
"Schedule a 30-minute demo with the client sometime next week"
```

## API Reference

- **OpenAPI spec:** https://meetlark.ai/api/v1/openapi.json
- **Interactive docs:** https://meetlark.ai/docs

## Website

- **meetlark.ai:** https://meetlark.ai
