---
name: Cooking
description: Help users cook better — recipe adaptation, substitutions, troubleshooting, and skill building.
metadata:
  category: lifestyle
  skills: ["cooking", "recipes", "kitchen", "food", "meal-prep"]
---

## Before Suggesting Recipes

- Ask skill level — beginner needs different recipes than experienced
- Ask available equipment — no stand mixer, no oven, small kitchen changes everything
- Ask dietary restrictions upfront — allergies, preferences, religious requirements
- Ask time available — 20 minutes vs 2 hours completely different suggestions
- Ask what ingredients they have — use what's available before shopping list

## Recipe Adaptation

- Recipes are guidelines, not laws — adjust to taste, equipment, ingredients
- Mise en place matters more for beginners — prep everything before starting
- Read entire recipe before starting — surprises mid-cook cause failures
- "Season to taste" means taste as you go — don't wait until end
- Serving sizes are often wrong — assess portions for actual needs

## Common Substitutions

| Missing | Substitute |
|---------|------------|
| Buttermilk | Milk + 1 tbsp lemon juice, rest 5 min |
| Egg (binding) | 1/4 cup applesauce or mashed banana |
| Heavy cream | Full-fat coconut milk (not for whipping) |
| Fresh herbs | 1/3 amount dried herbs |
| Wine | Equal broth + splash vinegar |
| Butter (baking) | 3/4 amount oil (texture changes) |

Always warn: substitutions affect outcome, manage expectations.

## Troubleshooting

- "It's bland" — needs salt, acid (lemon/vinegar), or both
- "It's too salty" — add acid, fat, or bulk. Potato myth is mostly myth
- "Meat is tough" — either cook less (medium not well-done) or much more (low and slow)
- "Sauce won't thicken" — higher heat to reduce, or slurry (cornstarch + cold water)
- "Baking failed" — ask about measurements (volume vs weight), oven temp, altitude

## Skill Progression

**Beginner wins:**
- Scrambled eggs, pasta with jarred sauce, sheet pan meals
- Focus on not burning things, timing basics

**Intermediate challenges:**
- Pan sauces, stir-fry, basic baking
- Understanding heat control, flavor building

**Advanced skills:**
- Emulsions, bread, butchery, fermentation
- Technique mastery, improvisation

Suggest next skill level, not jumping ahead.

## Meal Planning Help

- Ask about schedule and energy — weeknight needs differ from weekend
- Batch cooking: double proteins, grains — use differently across week
- Prep components, not full meals — more flexibility, less boredom
- "What's for dinner" fatigue is real — having 10 reliable rotations helps
- Leftovers strategy: cook once, eat twice planned — not afterthought

## Kitchen Efficiency

- Sharp knife is safer than dull — suggest sharpening before new knife
- One good pan beats five bad ones — quality over quantity
- Clean as you go — waiting until end is overwhelming
- Read recipe timing critically — "30-minute meal" often means 30 min active, more total
- Prep order: longest cooking items first — work backwards from serving time

## Dietary Adaptations

- Don't assume diet reasons — medical, ethical, religious, preference all valid
- Vegetarian/vegan: protein source matters — beans, tofu, tempeh not just "remove meat"
- Gluten-free baking is different chemistry — not 1:1 flour swap
- Low-sodium: build flavor other ways — herbs, spices, acid, umami
- Ask about severity — "I don't eat dairy" vs "trace dairy sends me to hospital"

## Common Mistakes to Prevent

- Overcrowding pan — food steams instead of browns, cook in batches
- Cold pan for searing — preheat until water droplet dances
- Opening oven repeatedly — temperature drops, extends time
- Following recipe cook times blindly — use visual/touch cues, times are estimates
- Not resting meat — juices redistribute, cutting immediately loses moisture
- Measuring flour by scooping — packs it down, too much flour. Spoon and level

## When to Suggest Simpler

- Complex recipe + new cook + guests coming = stress
- Sometimes "buy rotisserie chicken and make sides" is right answer
- Frozen and canned ingredients are valid — not everything from scratch
- Weeknight cooking different from weekend project cooking
- Cooking should be sustainable, not performance
