# Organizational Scaling

## Scaling Breaking Points

| Team Size | What Breaks | What to Build |
|-----------|-------------|---------------|
| 1-10 | Nothing yet | Enjoy the chaos |
| 10-30 | Communication | Team leads, basic processes |
| 30-100 | Coordination | Managers, departments, OKRs |
| 100-300 | Alignment | Directors, planning cycles |
| 300+ | Culture | VP layer, operating system |

## Organizational Design Principles

### Span of Control
- **ICs:** 5-8 direct reports per manager
- **Managers:** 4-6 per director
- **Too wide:** People don't get enough support
- **Too narrow:** Micromanagement, unnecessary hierarchy

### Team Topology

| Structure | Best For |
|-----------|----------|
| Functional | Specialists, efficiency, early stage |
| Product/Business Unit | Speed, ownership, growth stage |
| Matrix | Large orgs needing both (complex) |

### Accountability Principles

- **One owner per outcome** — DRI (Directly Responsible Individual)
- **Authority matches responsibility** — Can't own what you can't control
- **Clear escalation paths** — Know who decides when you can't

## Hiring Ahead

### Capacity Planning

```
Current capacity: [What team can deliver now]
Growth target: [What business needs in 6 months]
Gap: [Target - Current]
Lead time: [Hiring + onboarding time]
Start hiring: [When gap will exist - lead time]
```

### Hiring Triggers

| Signal | Action |
|--------|--------|
| Team consistently at 100%+ | Hire now, you're late |
| Team at 80-90% | Start recruiting |
| Major initiative planned | Hire ahead of kickoff |
| Key person risk | Cross-train or hire backup |

## Delegation Framework

### What to Delegate

| Delegate | Keep |
|----------|------|
| Repeatable decisions | Novel situations |
| Within established guidelines | Exceptions to policy |
| Skill-building opportunities | High-stakes, visible |
| Time-consuming but routine | Strategic relationships |

### Delegation Levels

1. **Do it, don't tell me** — Full autonomy
2. **Do it, keep me informed** — FYI updates
3. **Do it after I approve** — Check before acting
4. **Wait for me to decide** — Recommend, I decide
5. **I'll do it** — Not delegated

### Making Delegation Stick

- Clear outcome definition
- Authority explicitly granted
- Resources available
- Check-in schedule agreed
- Failure is learning, not punishment

## Restructuring

### When to Restructure

- Strategy has changed
- Scale has changed significantly
- Current structure causing repeated problems
- Merger or acquisition

### How to Restructure

1. **Design in private** — Small group, confidential
2. **Decide quickly** — Uncertainty is worse than change
3. **Communicate completely** — Everyone at once
4. **Execute immediately** — Rip the bandaid
5. **Support through transition** — Extra attention to affected
