# Cross-Functional Execution

## OKR Framework

### Structure

```
Objective: Qualitative, inspiring goal
├── Key Result 1: Measurable outcome (baseline → target)
├── Key Result 2: Measurable outcome (baseline → target)
└── Key Result 3: Measurable outcome (baseline → target)
```

### OKR Principles

- **Ambitious:** 70% achievement = success
- **Measurable:** Numbers, not activities
- **Time-bound:** Quarterly is typical
- **Aligned:** Team OKRs connect to company OKRs
- **Public:** Everyone can see everyone's OKRs

### Common OKR Mistakes

| Mistake | Fix |
|---------|-----|
| Too many OKRs | Max 3-5 objectives, 3-4 KRs each |
| KRs are tasks | Focus on outcomes, not outputs |
| Set and forget | Weekly check-ins required |
| 100% achievement | Stretch more, it's not a performance review |

## Weekly Operating Rhythm

### Company Level

| Day | Meeting | Purpose |
|-----|---------|---------|
| Monday | Leadership sync | Priorities, blockers, alignment |
| Friday | Metrics review | What happened this week |

### Team Level

| Meeting | Cadence | Duration | Focus |
|---------|---------|----------|-------|
| Standup | Daily | 15 min | What's happening today |
| Team sync | Weekly | 30-60 min | Progress, blockers, priorities |
| 1:1s | Weekly | 30 min | Individual support |
| Retrospective | Bi-weekly | 60 min | Process improvement |

## Dependency Management

### Dependency Tracking

| Dependency | Owner | Blocker | Due Date | Status |
|------------|-------|---------|----------|--------|
| API integration | Team A | Team B | Mar 15 | 🟡 At risk |
| Design assets | Design | None | Mar 10 | 🟢 On track |

### Reducing Dependencies

- **Decouple work** — Can teams work in parallel?
- **Clear interfaces** — Define handoffs precisely
- **Buffer time** — Dependencies slip; plan for it
- **Escalate early** — Don't wait until it's a crisis

## Escalation Framework

### When to Escalate

- Decision exceeds your authority
- Deadline at risk with no solution
- Cross-team conflict unresolved
- New risk discovered

### How to Escalate

```
Subject: [ESCALATION] Brief description

Situation: What's happening
Impact: Why it matters (metrics, dates)
Options: What we could do (with trade-offs)
Ask: What you need from the escalation recipient
Timeline: When you need a decision
```

## Communication Cadence

### Information Flow

| Type | Channel | Frequency |
|------|---------|-----------|
| Urgent issues | Slack/call | Immediately |
| Status updates | Written update | Weekly |
| Metrics/dashboards | Automated | Daily/real-time |
| Strategic updates | All-hands | Monthly |
| Deep dives | Document + meeting | As needed |

### Written Updates Template

```
## This Week
- [Completed items]

## Next Week  
- [Planned items]

## Blockers
- [What's stuck and what you need]

## Metrics
- [Key numbers]
```
