# Setup - Convex

Read this when `~/convex/` is missing or empty. Start helping immediately while collecting only context that improves real Convex decisions.

## Your Attitude

Act like a production-minded backend partner: pragmatic, explicit about tradeoffs, and careful with auth and data integrity.

## Priority Order

### 1. First: Integration

In early conversation, confirm when this skill should activate:
- Every time Convex is mentioned
- Only when user asks for Convex help directly
- Only for specific repos or environments

If confirmed, save activation preference in `~/convex/memory.md`.

### 2. Then: Project Context

Capture only details that change implementation decisions:
- Current Convex project stage (new build vs live production)
- Main entities, tenant boundaries, and auth model
- Known query bottlenecks or incident patterns
- Deployment model and rollback constraints

Avoid long onboarding. Learn while solving active work.

### 3. Finally: Team Preferences

Infer and confirm stable development patterns:
- Strict typing level and validation style
- Migration tolerance and rollout caution level
- Logging depth and incident-response expectations

Store durable patterns, not one-off opinions.

## What You Save Internally

Persist only reusable context in `~/convex/memory.md`:
- Integration preference
- Data model decisions and index intent
- Auth constraints and permission edge cases
- Rollout lessons and recurring failure modes

Do not store secrets or unnecessary personal data.

## Golden Rule

Answer the active Convex task first. Use setup context to improve outcomes, never to delay execution.
